/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters for the default Amazon Glue database. You use this database for SQL queries that you
 * write in a Managed Service for Apache Flink Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogConfiguration.Builder, CatalogConfiguration> {
    private static final SdkField<GlueDataCatalogConfiguration> GLUE_DATA_CATALOG_CONFIGURATION_FIELD = SdkField
            .<GlueDataCatalogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("GlueDataCatalogConfiguration")
            .getter(getter(CatalogConfiguration::glueDataCatalogConfiguration))
            .setter(setter(Builder::glueDataCatalogConfiguration))
            .constructor(GlueDataCatalogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueDataCatalogConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLUE_DATA_CATALOG_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final GlueDataCatalogConfiguration glueDataCatalogConfiguration;

    private CatalogConfiguration(BuilderImpl builder) {
        this.glueDataCatalogConfiguration = builder.glueDataCatalogConfiguration;
    }

    /**
     * <p>
     * The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink SQL
     * queries and table API transforms that you write in a Managed Service for Apache Flink Studio notebook.
     * </p>
     * 
     * @return The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink
     *         SQL queries and table API transforms that you write in a Managed Service for Apache Flink Studio
     *         notebook.
     */
    public final GlueDataCatalogConfiguration glueDataCatalogConfiguration() {
        return glueDataCatalogConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueDataCatalogConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogConfiguration)) {
            return false;
        }
        CatalogConfiguration other = (CatalogConfiguration) obj;
        return Objects.equals(glueDataCatalogConfiguration(), other.glueDataCatalogConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogConfiguration").add("GlueDataCatalogConfiguration", glueDataCatalogConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlueDataCatalogConfiguration":
            return Optional.ofNullable(clazz.cast(glueDataCatalogConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogConfiguration, T> g) {
        return obj -> g.apply((CatalogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogConfiguration> {
        /**
         * <p>
         * The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink SQL
         * queries and table API transforms that you write in a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param glueDataCatalogConfiguration
         *        The configuration parameters for the default Amazon Glue database. You use this database for Apache
         *        Flink SQL queries and table API transforms that you write in a Managed Service for Apache Flink Studio
         *        notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueDataCatalogConfiguration(GlueDataCatalogConfiguration glueDataCatalogConfiguration);

        /**
         * <p>
         * The configuration parameters for the default Amazon Glue database. You use this database for Apache Flink SQL
         * queries and table API transforms that you write in a Managed Service for Apache Flink Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueDataCatalogConfiguration.Builder}
         * avoiding the need to create one manually via {@link GlueDataCatalogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueDataCatalogConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #glueDataCatalogConfiguration(GlueDataCatalogConfiguration)}.
         * 
         * @param glueDataCatalogConfiguration
         *        a consumer that will call methods on {@link GlueDataCatalogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueDataCatalogConfiguration(GlueDataCatalogConfiguration)
         */
        default Builder glueDataCatalogConfiguration(Consumer<GlueDataCatalogConfiguration.Builder> glueDataCatalogConfiguration) {
            return glueDataCatalogConfiguration(GlueDataCatalogConfiguration.builder()
                    .applyMutation(glueDataCatalogConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueDataCatalogConfiguration glueDataCatalogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogConfiguration model) {
            glueDataCatalogConfiguration(model.glueDataCatalogConfiguration);
        }

        public final GlueDataCatalogConfiguration.Builder getGlueDataCatalogConfiguration() {
            return glueDataCatalogConfiguration != null ? glueDataCatalogConfiguration.toBuilder() : null;
        }

        public final void setGlueDataCatalogConfiguration(GlueDataCatalogConfiguration.BuilderImpl glueDataCatalogConfiguration) {
            this.glueDataCatalogConfiguration = glueDataCatalogConfiguration != null ? glueDataCatalogConfiguration.build()
                    : null;
        }

        @Override
        public final Builder glueDataCatalogConfiguration(GlueDataCatalogConfiguration glueDataCatalogConfiguration) {
            this.glueDataCatalogConfiguration = glueDataCatalogConfiguration;
            return this;
        }

        @Override
        public CatalogConfiguration build() {
            return new CatalogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
