/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes execution properties for a Managed Service for Apache Flink application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentProperties.Builder, EnvironmentProperties> {
    private static final SdkField<List<PropertyGroup>> PROPERTY_GROUPS_FIELD = SdkField
            .<List<PropertyGroup>> builder(MarshallingType.LIST)
            .memberName("PropertyGroups")
            .getter(getter(EnvironmentProperties::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PropertyGroup> propertyGroups;

    private EnvironmentProperties(BuilderImpl builder) {
        this.propertyGroups = builder.propertyGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the execution property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return Describes the execution property groups.
     */
    public final List<PropertyGroup> propertyGroups() {
        return propertyGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProperties)) {
            return false;
        }
        EnvironmentProperties other = (EnvironmentProperties) obj;
        return hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(propertyGroups(), other.propertyGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentProperties").add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentProperties, T> g) {
        return obj -> g.apply((EnvironmentProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentProperties> {
        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroups
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Collection<PropertyGroup> propertyGroups);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroups
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(PropertyGroup... propertyGroups);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyGroups(List<PropertyGroup>)}.
         * 
         * @param propertyGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyGroups(java.util.Collection<PropertyGroup>)
         */
        Builder propertyGroups(Consumer<PropertyGroup.Builder>... propertyGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<PropertyGroup> propertyGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentProperties model) {
            propertyGroups(model.propertyGroups);
        }

        public final List<PropertyGroup.Builder> getPropertyGroups() {
            List<PropertyGroup.Builder> result = PropertyGroupsCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Collection<PropertyGroup.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Collection<PropertyGroup> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copy(propertyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(PropertyGroup... propertyGroups) {
            propertyGroups(Arrays.asList(propertyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(Consumer<PropertyGroup.Builder>... propertyGroups) {
            propertyGroups(Stream.of(propertyGroups).map(c -> PropertyGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnvironmentProperties build() {
            return new EnvironmentProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
