/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration parameters for a Managed Service for Apache Flink application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlinkApplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<FlinkApplicationConfigurationDescription.Builder, FlinkApplicationConfigurationDescription> {
    private static final SdkField<CheckpointConfigurationDescription> CHECKPOINT_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<CheckpointConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("CheckpointConfigurationDescription")
            .getter(getter(FlinkApplicationConfigurationDescription::checkpointConfigurationDescription))
            .setter(setter(Builder::checkpointConfigurationDescription))
            .constructor(CheckpointConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfigurationDescription")
                    .build()).build();

    private static final SdkField<MonitoringConfigurationDescription> MONITORING_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<MonitoringConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringConfigurationDescription")
            .getter(getter(FlinkApplicationConfigurationDescription::monitoringConfigurationDescription))
            .setter(setter(Builder::monitoringConfigurationDescription))
            .constructor(MonitoringConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationDescription")
                    .build()).build();

    private static final SdkField<ParallelismConfigurationDescription> PARALLELISM_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ParallelismConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ParallelismConfigurationDescription")
            .getter(getter(FlinkApplicationConfigurationDescription::parallelismConfigurationDescription))
            .setter(setter(Builder::parallelismConfigurationDescription))
            .constructor(ParallelismConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ParallelismConfigurationDescription").build()).build();

    private static final SdkField<String> JOB_PLAN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobPlanDescription").getter(getter(FlinkApplicationConfigurationDescription::jobPlanDescription))
            .setter(setter(Builder::jobPlanDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobPlanDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHECKPOINT_CONFIGURATION_DESCRIPTION_FIELD, MONITORING_CONFIGURATION_DESCRIPTION_FIELD,
            PARALLELISM_CONFIGURATION_DESCRIPTION_FIELD, JOB_PLAN_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CheckpointConfigurationDescription checkpointConfigurationDescription;

    private final MonitoringConfigurationDescription monitoringConfigurationDescription;

    private final ParallelismConfigurationDescription parallelismConfigurationDescription;

    private final String jobPlanDescription;

    private FlinkApplicationConfigurationDescription(BuilderImpl builder) {
        this.checkpointConfigurationDescription = builder.checkpointConfigurationDescription;
        this.monitoringConfigurationDescription = builder.monitoringConfigurationDescription;
        this.parallelismConfigurationDescription = builder.parallelismConfigurationDescription;
        this.jobPlanDescription = builder.jobPlanDescription;
    }

    /**
     * <p>
     * Describes an application's checkpointing configuration. Checkpointing is the process of persisting application
     * state for fault tolerance.
     * </p>
     * 
     * @return Describes an application's checkpointing configuration. Checkpointing is the process of persisting
     *         application state for fault tolerance.
     */
    public final CheckpointConfigurationDescription checkpointConfigurationDescription() {
        return checkpointConfigurationDescription;
    }

    /**
     * <p>
     * Describes configuration parameters for Amazon CloudWatch logging for an application.
     * </p>
     * 
     * @return Describes configuration parameters for Amazon CloudWatch logging for an application.
     */
    public final MonitoringConfigurationDescription monitoringConfigurationDescription() {
        return monitoringConfigurationDescription;
    }

    /**
     * <p>
     * Describes parameters for how an application executes multiple tasks simultaneously.
     * </p>
     * 
     * @return Describes parameters for how an application executes multiple tasks simultaneously.
     */
    public final ParallelismConfigurationDescription parallelismConfigurationDescription() {
        return parallelismConfigurationDescription;
    }

    /**
     * <p>
     * The job plan for an application. For more information about the job plan, see <a
     * href="https://nightlies.apache.org/flink/flink-docs-release-1.19/internals/job_scheduling.html">Jobs and
     * Scheduling</a> in the <a href="https://nightlies.apache.org/flink/flink-docs-release-1.19/">Apache Flink
     * Documentation</a>. To retrieve the job plan for the application, use the
     * <a>DescribeApplicationRequest$IncludeAdditionalDetails</a> parameter of the <a>DescribeApplication</a> operation.
     * </p>
     * 
     * @return The job plan for an application. For more information about the job plan, see <a
     *         href="https://nightlies.apache.org/flink/flink-docs-release-1.19/internals/job_scheduling.html">Jobs and
     *         Scheduling</a> in the <a href="https://nightlies.apache.org/flink/flink-docs-release-1.19/">Apache Flink
     *         Documentation</a>. To retrieve the job plan for the application, use the
     *         <a>DescribeApplicationRequest$IncludeAdditionalDetails</a> parameter of the <a>DescribeApplication</a>
     *         operation.
     */
    public final String jobPlanDescription() {
        return jobPlanDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(jobPlanDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkApplicationConfigurationDescription)) {
            return false;
        }
        FlinkApplicationConfigurationDescription other = (FlinkApplicationConfigurationDescription) obj;
        return Objects.equals(checkpointConfigurationDescription(), other.checkpointConfigurationDescription())
                && Objects.equals(monitoringConfigurationDescription(), other.monitoringConfigurationDescription())
                && Objects.equals(parallelismConfigurationDescription(), other.parallelismConfigurationDescription())
                && Objects.equals(jobPlanDescription(), other.jobPlanDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlinkApplicationConfigurationDescription")
                .add("CheckpointConfigurationDescription", checkpointConfigurationDescription())
                .add("MonitoringConfigurationDescription", monitoringConfigurationDescription())
                .add("ParallelismConfigurationDescription", parallelismConfigurationDescription())
                .add("JobPlanDescription", jobPlanDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckpointConfigurationDescription":
            return Optional.ofNullable(clazz.cast(checkpointConfigurationDescription()));
        case "MonitoringConfigurationDescription":
            return Optional.ofNullable(clazz.cast(monitoringConfigurationDescription()));
        case "ParallelismConfigurationDescription":
            return Optional.ofNullable(clazz.cast(parallelismConfigurationDescription()));
        case "JobPlanDescription":
            return Optional.ofNullable(clazz.cast(jobPlanDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlinkApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((FlinkApplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlinkApplicationConfigurationDescription> {
        /**
         * <p>
         * Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance.
         * </p>
         * 
         * @param checkpointConfigurationDescription
         *        Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         *        application state for fault tolerance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfigurationDescription(CheckpointConfigurationDescription checkpointConfigurationDescription);

        /**
         * <p>
         * Describes an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CheckpointConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link CheckpointConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CheckpointConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #checkpointConfigurationDescription(CheckpointConfigurationDescription)}.
         * 
         * @param checkpointConfigurationDescription
         *        a consumer that will call methods on {@link CheckpointConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfigurationDescription(CheckpointConfigurationDescription)
         */
        default Builder checkpointConfigurationDescription(
                Consumer<CheckpointConfigurationDescription.Builder> checkpointConfigurationDescription) {
            return checkpointConfigurationDescription(CheckpointConfigurationDescription.builder()
                    .applyMutation(checkpointConfigurationDescription).build());
        }

        /**
         * <p>
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * 
         * @param monitoringConfigurationDescription
         *        Describes configuration parameters for Amazon CloudWatch logging for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfigurationDescription(MonitoringConfigurationDescription monitoringConfigurationDescription);

        /**
         * <p>
         * Describes configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MonitoringConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link MonitoringConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #monitoringConfigurationDescription(MonitoringConfigurationDescription)}.
         * 
         * @param monitoringConfigurationDescription
         *        a consumer that will call methods on {@link MonitoringConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfigurationDescription(MonitoringConfigurationDescription)
         */
        default Builder monitoringConfigurationDescription(
                Consumer<MonitoringConfigurationDescription.Builder> monitoringConfigurationDescription) {
            return monitoringConfigurationDescription(MonitoringConfigurationDescription.builder()
                    .applyMutation(monitoringConfigurationDescription).build());
        }

        /**
         * <p>
         * Describes parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * 
         * @param parallelismConfigurationDescription
         *        Describes parameters for how an application executes multiple tasks simultaneously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfigurationDescription(ParallelismConfigurationDescription parallelismConfigurationDescription);

        /**
         * <p>
         * Describes parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParallelismConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ParallelismConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelismConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #parallelismConfigurationDescription(ParallelismConfigurationDescription)}.
         * 
         * @param parallelismConfigurationDescription
         *        a consumer that will call methods on {@link ParallelismConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfigurationDescription(ParallelismConfigurationDescription)
         */
        default Builder parallelismConfigurationDescription(
                Consumer<ParallelismConfigurationDescription.Builder> parallelismConfigurationDescription) {
            return parallelismConfigurationDescription(ParallelismConfigurationDescription.builder()
                    .applyMutation(parallelismConfigurationDescription).build());
        }

        /**
         * <p>
         * The job plan for an application. For more information about the job plan, see <a
         * href="https://nightlies.apache.org/flink/flink-docs-release-1.19/internals/job_scheduling.html">Jobs and
         * Scheduling</a> in the <a href="https://nightlies.apache.org/flink/flink-docs-release-1.19/">Apache Flink
         * Documentation</a>. To retrieve the job plan for the application, use the
         * <a>DescribeApplicationRequest$IncludeAdditionalDetails</a> parameter of the <a>DescribeApplication</a>
         * operation.
         * </p>
         * 
         * @param jobPlanDescription
         *        The job plan for an application. For more information about the job plan, see <a
         *        href="https://nightlies.apache.org/flink/flink-docs-release-1.19/internals/job_scheduling.html">Jobs
         *        and Scheduling</a> in the <a href="https://nightlies.apache.org/flink/flink-docs-release-1.19/">Apache
         *        Flink Documentation</a>. To retrieve the job plan for the application, use the
         *        <a>DescribeApplicationRequest$IncludeAdditionalDetails</a> parameter of the <a>DescribeApplication</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobPlanDescription(String jobPlanDescription);
    }

    static final class BuilderImpl implements Builder {
        private CheckpointConfigurationDescription checkpointConfigurationDescription;

        private MonitoringConfigurationDescription monitoringConfigurationDescription;

        private ParallelismConfigurationDescription parallelismConfigurationDescription;

        private String jobPlanDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkApplicationConfigurationDescription model) {
            checkpointConfigurationDescription(model.checkpointConfigurationDescription);
            monitoringConfigurationDescription(model.monitoringConfigurationDescription);
            parallelismConfigurationDescription(model.parallelismConfigurationDescription);
            jobPlanDescription(model.jobPlanDescription);
        }

        public final CheckpointConfigurationDescription.Builder getCheckpointConfigurationDescription() {
            return checkpointConfigurationDescription != null ? checkpointConfigurationDescription.toBuilder() : null;
        }

        public final void setCheckpointConfigurationDescription(
                CheckpointConfigurationDescription.BuilderImpl checkpointConfigurationDescription) {
            this.checkpointConfigurationDescription = checkpointConfigurationDescription != null ? checkpointConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder checkpointConfigurationDescription(
                CheckpointConfigurationDescription checkpointConfigurationDescription) {
            this.checkpointConfigurationDescription = checkpointConfigurationDescription;
            return this;
        }

        public final MonitoringConfigurationDescription.Builder getMonitoringConfigurationDescription() {
            return monitoringConfigurationDescription != null ? monitoringConfigurationDescription.toBuilder() : null;
        }

        public final void setMonitoringConfigurationDescription(
                MonitoringConfigurationDescription.BuilderImpl monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription != null ? monitoringConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder monitoringConfigurationDescription(
                MonitoringConfigurationDescription monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription;
            return this;
        }

        public final ParallelismConfigurationDescription.Builder getParallelismConfigurationDescription() {
            return parallelismConfigurationDescription != null ? parallelismConfigurationDescription.toBuilder() : null;
        }

        public final void setParallelismConfigurationDescription(
                ParallelismConfigurationDescription.BuilderImpl parallelismConfigurationDescription) {
            this.parallelismConfigurationDescription = parallelismConfigurationDescription != null ? parallelismConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder parallelismConfigurationDescription(
                ParallelismConfigurationDescription parallelismConfigurationDescription) {
            this.parallelismConfigurationDescription = parallelismConfigurationDescription;
            return this;
        }

        public final String getJobPlanDescription() {
            return jobPlanDescription;
        }

        public final void setJobPlanDescription(String jobPlanDescription) {
            this.jobPlanDescription = jobPlanDescription;
        }

        @Override
        public final Builder jobPlanDescription(String jobPlanDescription) {
            this.jobPlanDescription = jobPlanDescription;
            return this;
        }

        @Override
        public FlinkApplicationConfigurationDescription build() {
            return new FlinkApplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
