/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes code configuration updates for an application. This is supported for a Managed Service for Apache Flink
 * application or a SQL-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationCodeConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationCodeConfigurationUpdate.Builder, ApplicationCodeConfigurationUpdate> {
    private static final SdkField<String> CODE_CONTENT_TYPE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeContentTypeUpdate")
            .getter(getter(ApplicationCodeConfigurationUpdate::codeContentTypeUpdateAsString))
            .setter(setter(Builder::codeContentTypeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentTypeUpdate").build())
            .build();

    private static final SdkField<CodeContentUpdate> CODE_CONTENT_UPDATE_FIELD = SdkField
            .<CodeContentUpdate> builder(MarshallingType.SDK_POJO).memberName("CodeContentUpdate")
            .getter(getter(ApplicationCodeConfigurationUpdate::codeContentUpdate)).setter(setter(Builder::codeContentUpdate))
            .constructor(CodeContentUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_CONTENT_TYPE_UPDATE_FIELD, CODE_CONTENT_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codeContentTypeUpdate;

    private final CodeContentUpdate codeContentUpdate;

    private ApplicationCodeConfigurationUpdate(BuilderImpl builder) {
        this.codeContentTypeUpdate = builder.codeContentTypeUpdate;
        this.codeContentUpdate = builder.codeContentUpdate;
    }

    /**
     * <p>
     * Describes updates to the code content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codeContentTypeUpdate} will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #codeContentTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the code content type.
     * @see CodeContentType
     */
    public final CodeContentType codeContentTypeUpdate() {
        return CodeContentType.fromValue(codeContentTypeUpdate);
    }

    /**
     * <p>
     * Describes updates to the code content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codeContentTypeUpdate} will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #codeContentTypeUpdateAsString}.
     * </p>
     * 
     * @return Describes updates to the code content type.
     * @see CodeContentType
     */
    public final String codeContentTypeUpdateAsString() {
        return codeContentTypeUpdate;
    }

    /**
     * <p>
     * Describes updates to the code content of an application.
     * </p>
     * 
     * @return Describes updates to the code content of an application.
     */
    public final CodeContentUpdate codeContentUpdate() {
        return codeContentUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeContentTypeUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codeContentUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCodeConfigurationUpdate)) {
            return false;
        }
        ApplicationCodeConfigurationUpdate other = (ApplicationCodeConfigurationUpdate) obj;
        return Objects.equals(codeContentTypeUpdateAsString(), other.codeContentTypeUpdateAsString())
                && Objects.equals(codeContentUpdate(), other.codeContentUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationCodeConfigurationUpdate")
                .add("CodeContentTypeUpdate", codeContentTypeUpdateAsString()).add("CodeContentUpdate", codeContentUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeContentTypeUpdate":
            return Optional.ofNullable(clazz.cast(codeContentTypeUpdateAsString()));
        case "CodeContentUpdate":
            return Optional.ofNullable(clazz.cast(codeContentUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCodeConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationCodeConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationCodeConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to the code content type.
         * </p>
         * 
         * @param codeContentTypeUpdate
         *        Describes updates to the code content type.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentTypeUpdate(String codeContentTypeUpdate);

        /**
         * <p>
         * Describes updates to the code content type.
         * </p>
         * 
         * @param codeContentTypeUpdate
         *        Describes updates to the code content type.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentTypeUpdate(CodeContentType codeContentTypeUpdate);

        /**
         * <p>
         * Describes updates to the code content of an application.
         * </p>
         * 
         * @param codeContentUpdate
         *        Describes updates to the code content of an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeContentUpdate(CodeContentUpdate codeContentUpdate);

        /**
         * <p>
         * Describes updates to the code content of an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeContentUpdate.Builder} avoiding the
         * need to create one manually via {@link CodeContentUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeContentUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #codeContentUpdate(CodeContentUpdate)}.
         * 
         * @param codeContentUpdate
         *        a consumer that will call methods on {@link CodeContentUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeContentUpdate(CodeContentUpdate)
         */
        default Builder codeContentUpdate(Consumer<CodeContentUpdate.Builder> codeContentUpdate) {
            return codeContentUpdate(CodeContentUpdate.builder().applyMutation(codeContentUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String codeContentTypeUpdate;

        private CodeContentUpdate codeContentUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCodeConfigurationUpdate model) {
            codeContentTypeUpdate(model.codeContentTypeUpdate);
            codeContentUpdate(model.codeContentUpdate);
        }

        public final String getCodeContentTypeUpdate() {
            return codeContentTypeUpdate;
        }

        public final void setCodeContentTypeUpdate(String codeContentTypeUpdate) {
            this.codeContentTypeUpdate = codeContentTypeUpdate;
        }

        @Override
        public final Builder codeContentTypeUpdate(String codeContentTypeUpdate) {
            this.codeContentTypeUpdate = codeContentTypeUpdate;
            return this;
        }

        @Override
        public final Builder codeContentTypeUpdate(CodeContentType codeContentTypeUpdate) {
            this.codeContentTypeUpdate(codeContentTypeUpdate == null ? null : codeContentTypeUpdate.toString());
            return this;
        }

        public final CodeContentUpdate.Builder getCodeContentUpdate() {
            return codeContentUpdate != null ? codeContentUpdate.toBuilder() : null;
        }

        public final void setCodeContentUpdate(CodeContentUpdate.BuilderImpl codeContentUpdate) {
            this.codeContentUpdate = codeContentUpdate != null ? codeContentUpdate.build() : null;
        }

        @Override
        public final Builder codeContentUpdate(CodeContentUpdate codeContentUpdate) {
            this.codeContentUpdate = codeContentUpdate;
            return this;
        }

        @Override
        public ApplicationCodeConfigurationUpdate build() {
            return new ApplicationCodeConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
