/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides a description of the operation, such as the operation-type and status
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationOperationInfoDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationOperationInfoDetails.Builder, ApplicationOperationInfoDetails> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(ApplicationOperationInfoDetails::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ApplicationOperationInfoDetails::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ApplicationOperationInfoDetails::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationStatus").getter(getter(ApplicationOperationInfoDetails::operationStatusAsString))
            .setter(setter(Builder::operationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()).build();

    private static final SdkField<ApplicationVersionChangeDetails> APPLICATION_VERSION_CHANGE_DETAILS_FIELD = SdkField
            .<ApplicationVersionChangeDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationVersionChangeDetails")
            .getter(getter(ApplicationOperationInfoDetails::applicationVersionChangeDetails))
            .setter(setter(Builder::applicationVersionChangeDetails))
            .constructor(ApplicationVersionChangeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionChangeDetails")
                    .build()).build();

    private static final SdkField<OperationFailureDetails> OPERATION_FAILURE_DETAILS_FIELD = SdkField
            .<OperationFailureDetails> builder(MarshallingType.SDK_POJO).memberName("OperationFailureDetails")
            .getter(getter(ApplicationOperationInfoDetails::operationFailureDetails))
            .setter(setter(Builder::operationFailureDetails)).constructor(OperationFailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationFailureDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, OPERATION_STATUS_FIELD, APPLICATION_VERSION_CHANGE_DETAILS_FIELD,
            OPERATION_FAILURE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operation;

    private final Instant startTime;

    private final Instant endTime;

    private final String operationStatus;

    private final ApplicationVersionChangeDetails applicationVersionChangeDetails;

    private final OperationFailureDetails operationFailureDetails;

    private ApplicationOperationInfoDetails(BuilderImpl builder) {
        this.operation = builder.operation;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.operationStatus = builder.operationStatus;
        this.applicationVersionChangeDetails = builder.applicationVersionChangeDetails;
        this.operationFailureDetails = builder.operationFailureDetails;
    }

    /**
     * Returns the value of the Operation property for this object.
     * 
     * @return The value of the Operation property for this object.
     */
    public final String operation() {
        return operation;
    }

    /**
     * The timestamp at which the operation was created
     * 
     * @return The timestamp at which the operation was created
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * The timestamp at which the operation finished for the application
     * 
     * @return The timestamp at which the operation finished for the application
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns the value of the OperationStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The value of the OperationStatus property for this object.
     * @see OperationStatus
     */
    public final OperationStatus operationStatus() {
        return OperationStatus.fromValue(operationStatus);
    }

    /**
     * Returns the value of the OperationStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return The value of the OperationStatus property for this object.
     * @see OperationStatus
     */
    public final String operationStatusAsString() {
        return operationStatus;
    }

    /**
     * Returns the value of the ApplicationVersionChangeDetails property for this object.
     * 
     * @return The value of the ApplicationVersionChangeDetails property for this object.
     */
    public final ApplicationVersionChangeDetails applicationVersionChangeDetails() {
        return applicationVersionChangeDetails;
    }

    /**
     * Returns the value of the OperationFailureDetails property for this object.
     * 
     * @return The value of the OperationFailureDetails property for this object.
     */
    public final OperationFailureDetails operationFailureDetails() {
        return operationFailureDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionChangeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(operationFailureDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationOperationInfoDetails)) {
            return false;
        }
        ApplicationOperationInfoDetails other = (ApplicationOperationInfoDetails) obj;
        return Objects.equals(operation(), other.operation()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(operationStatusAsString(), other.operationStatusAsString())
                && Objects.equals(applicationVersionChangeDetails(), other.applicationVersionChangeDetails())
                && Objects.equals(operationFailureDetails(), other.operationFailureDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationOperationInfoDetails").add("Operation", operation()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("OperationStatus", operationStatusAsString())
                .add("ApplicationVersionChangeDetails", applicationVersionChangeDetails())
                .add("OperationFailureDetails", operationFailureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "OperationStatus":
            return Optional.ofNullable(clazz.cast(operationStatusAsString()));
        case "ApplicationVersionChangeDetails":
            return Optional.ofNullable(clazz.cast(applicationVersionChangeDetails()));
        case "OperationFailureDetails":
            return Optional.ofNullable(clazz.cast(operationFailureDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationOperationInfoDetails, T> g) {
        return obj -> g.apply((ApplicationOperationInfoDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationOperationInfoDetails> {
        /**
         * Sets the value of the Operation property for this object.
         *
         * @param operation
         *        The new value for the Operation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * The timestamp at which the operation was created
         * 
         * @param startTime
         *        The timestamp at which the operation was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * The timestamp at which the operation finished for the application
         * 
         * @param endTime
         *        The timestamp at which the operation finished for the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * Sets the value of the OperationStatus property for this object.
         *
         * @param operationStatus
         *        The new value for the OperationStatus property for this object.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(String operationStatus);

        /**
         * Sets the value of the OperationStatus property for this object.
         *
         * @param operationStatus
         *        The new value for the OperationStatus property for this object.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(OperationStatus operationStatus);

        /**
         * Sets the value of the ApplicationVersionChangeDetails property for this object.
         *
         * @param applicationVersionChangeDetails
         *        The new value for the ApplicationVersionChangeDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionChangeDetails(ApplicationVersionChangeDetails applicationVersionChangeDetails);

        /**
         * Sets the value of the ApplicationVersionChangeDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationVersionChangeDetails.Builder}
         * avoiding the need to create one manually via {@link ApplicationVersionChangeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationVersionChangeDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationVersionChangeDetails(ApplicationVersionChangeDetails)}.
         * 
         * @param applicationVersionChangeDetails
         *        a consumer that will call methods on {@link ApplicationVersionChangeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersionChangeDetails(ApplicationVersionChangeDetails)
         */
        default Builder applicationVersionChangeDetails(
                Consumer<ApplicationVersionChangeDetails.Builder> applicationVersionChangeDetails) {
            return applicationVersionChangeDetails(ApplicationVersionChangeDetails.builder()
                    .applyMutation(applicationVersionChangeDetails).build());
        }

        /**
         * Sets the value of the OperationFailureDetails property for this object.
         *
         * @param operationFailureDetails
         *        The new value for the OperationFailureDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationFailureDetails(OperationFailureDetails operationFailureDetails);

        /**
         * Sets the value of the OperationFailureDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OperationFailureDetails.Builder} avoiding
         * the need to create one manually via {@link OperationFailureDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperationFailureDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #operationFailureDetails(OperationFailureDetails)}.
         * 
         * @param operationFailureDetails
         *        a consumer that will call methods on {@link OperationFailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationFailureDetails(OperationFailureDetails)
         */
        default Builder operationFailureDetails(Consumer<OperationFailureDetails.Builder> operationFailureDetails) {
            return operationFailureDetails(OperationFailureDetails.builder().applyMutation(operationFailureDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String operation;

        private Instant startTime;

        private Instant endTime;

        private String operationStatus;

        private ApplicationVersionChangeDetails applicationVersionChangeDetails;

        private OperationFailureDetails operationFailureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationOperationInfoDetails model) {
            operation(model.operation);
            startTime(model.startTime);
            endTime(model.endTime);
            operationStatus(model.operationStatus);
            applicationVersionChangeDetails(model.applicationVersionChangeDetails);
            operationFailureDetails(model.operationFailureDetails);
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationStatus() {
            return operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final ApplicationVersionChangeDetails.Builder getApplicationVersionChangeDetails() {
            return applicationVersionChangeDetails != null ? applicationVersionChangeDetails.toBuilder() : null;
        }

        public final void setApplicationVersionChangeDetails(
                ApplicationVersionChangeDetails.BuilderImpl applicationVersionChangeDetails) {
            this.applicationVersionChangeDetails = applicationVersionChangeDetails != null ? applicationVersionChangeDetails
                    .build() : null;
        }

        @Override
        public final Builder applicationVersionChangeDetails(ApplicationVersionChangeDetails applicationVersionChangeDetails) {
            this.applicationVersionChangeDetails = applicationVersionChangeDetails;
            return this;
        }

        public final OperationFailureDetails.Builder getOperationFailureDetails() {
            return operationFailureDetails != null ? operationFailureDetails.toBuilder() : null;
        }

        public final void setOperationFailureDetails(OperationFailureDetails.BuilderImpl operationFailureDetails) {
            this.operationFailureDetails = operationFailureDetails != null ? operationFailureDetails.build() : null;
        }

        @Override
        public final Builder operationFailureDetails(OperationFailureDetails operationFailureDetails) {
            this.operationFailureDetails = operationFailureDetails;
            return this;
        }

        @Override
        public ApplicationOperationInfoDetails build() {
            return new ApplicationOperationInfoDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
