/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides a description of the operation failure
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationFailureDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<OperationFailureDetails.Builder, OperationFailureDetails> {
    private static final SdkField<String> ROLLBACK_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RollbackOperationId").getter(getter(OperationFailureDetails::rollbackOperationId))
            .setter(setter(Builder::rollbackOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackOperationId").build())
            .build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorInfo").getter(getter(OperationFailureDetails::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLBACK_OPERATION_ID_FIELD,
            ERROR_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rollbackOperationId;

    private final ErrorInfo errorInfo;

    private OperationFailureDetails(BuilderImpl builder) {
        this.rollbackOperationId = builder.rollbackOperationId;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * Provides the operation ID of a system-rollback operation executed due to failure in the current operation
     * 
     * @return Provides the operation ID of a system-rollback operation executed due to failure in the current operation
     */
    public final String rollbackOperationId() {
        return rollbackOperationId;
    }

    /**
     * Returns the value of the ErrorInfo property for this object.
     * 
     * @return The value of the ErrorInfo property for this object.
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollbackOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationFailureDetails)) {
            return false;
        }
        OperationFailureDetails other = (OperationFailureDetails) obj;
        return Objects.equals(rollbackOperationId(), other.rollbackOperationId())
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationFailureDetails").add("RollbackOperationId", rollbackOperationId())
                .add("ErrorInfo", errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollbackOperationId":
            return Optional.ofNullable(clazz.cast(rollbackOperationId()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationFailureDetails, T> g) {
        return obj -> g.apply((OperationFailureDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationFailureDetails> {
        /**
         * Provides the operation ID of a system-rollback operation executed due to failure in the current operation
         * 
         * @param rollbackOperationId
         *        Provides the operation ID of a system-rollback operation executed due to failure in the current
         *        operation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackOperationId(String rollbackOperationId);

        /**
         * Sets the value of the ErrorInfo property for this object.
         *
         * @param errorInfo
         *        The new value for the ErrorInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * Sets the value of the ErrorInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String rollbackOperationId;

        private ErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationFailureDetails model) {
            rollbackOperationId(model.rollbackOperationId);
            errorInfo(model.errorInfo);
        }

        public final String getRollbackOperationId() {
            return rollbackOperationId;
        }

        public final void setRollbackOperationId(String rollbackOperationId) {
            this.rollbackOperationId = rollbackOperationId;
        }

        @Override
        public final Builder rollbackOperationId(String rollbackOperationId) {
            this.rollbackOperationId = rollbackOperationId;
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        @Override
        public OperationFailureDetails build() {
            return new OperationFailureDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
