/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Contains information about the application version changes due to an operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationVersionChangeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationVersionChangeDetails.Builder, ApplicationVersionChangeDetails> {
    private static final SdkField<Long> APPLICATION_VERSION_UPDATED_FROM_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionUpdatedFrom")
            .getter(getter(ApplicationVersionChangeDetails::applicationVersionUpdatedFrom))
            .setter(setter(Builder::applicationVersionUpdatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionUpdatedFrom")
                    .build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_UPDATED_TO_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionUpdatedTo")
            .getter(getter(ApplicationVersionChangeDetails::applicationVersionUpdatedTo))
            .setter(setter(Builder::applicationVersionUpdatedTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionUpdatedTo")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_VERSION_UPDATED_FROM_FIELD, APPLICATION_VERSION_UPDATED_TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long applicationVersionUpdatedFrom;

    private final Long applicationVersionUpdatedTo;

    private ApplicationVersionChangeDetails(BuilderImpl builder) {
        this.applicationVersionUpdatedFrom = builder.applicationVersionUpdatedFrom;
        this.applicationVersionUpdatedTo = builder.applicationVersionUpdatedTo;
    }

    /**
     * The operation was performed on this version of the application
     * 
     * @return The operation was performed on this version of the application
     */
    public final Long applicationVersionUpdatedFrom() {
        return applicationVersionUpdatedFrom;
    }

    /**
     * The operation execution resulted in the transition to the following version of the application
     * 
     * @return The operation execution resulted in the transition to the following version of the application
     */
    public final Long applicationVersionUpdatedTo() {
        return applicationVersionUpdatedTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionUpdatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionUpdatedTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionChangeDetails)) {
            return false;
        }
        ApplicationVersionChangeDetails other = (ApplicationVersionChangeDetails) obj;
        return Objects.equals(applicationVersionUpdatedFrom(), other.applicationVersionUpdatedFrom())
                && Objects.equals(applicationVersionUpdatedTo(), other.applicationVersionUpdatedTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationVersionChangeDetails")
                .add("ApplicationVersionUpdatedFrom", applicationVersionUpdatedFrom())
                .add("ApplicationVersionUpdatedTo", applicationVersionUpdatedTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersionUpdatedFrom":
            return Optional.ofNullable(clazz.cast(applicationVersionUpdatedFrom()));
        case "ApplicationVersionUpdatedTo":
            return Optional.ofNullable(clazz.cast(applicationVersionUpdatedTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionChangeDetails, T> g) {
        return obj -> g.apply((ApplicationVersionChangeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationVersionChangeDetails> {
        /**
         * The operation was performed on this version of the application
         * 
         * @param applicationVersionUpdatedFrom
         *        The operation was performed on this version of the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom);

        /**
         * The operation execution resulted in the transition to the following version of the application
         * 
         * @param applicationVersionUpdatedTo
         *        The operation execution resulted in the transition to the following version of the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionUpdatedTo(Long applicationVersionUpdatedTo);
    }

    static final class BuilderImpl implements Builder {
        private Long applicationVersionUpdatedFrom;

        private Long applicationVersionUpdatedTo;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionChangeDetails model) {
            applicationVersionUpdatedFrom(model.applicationVersionUpdatedFrom);
            applicationVersionUpdatedTo(model.applicationVersionUpdatedTo);
        }

        public final Long getApplicationVersionUpdatedFrom() {
            return applicationVersionUpdatedFrom;
        }

        public final void setApplicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
        }

        @Override
        public final Builder applicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
            return this;
        }

        public final Long getApplicationVersionUpdatedTo() {
            return applicationVersionUpdatedTo;
        }

        public final void setApplicationVersionUpdatedTo(Long applicationVersionUpdatedTo) {
            this.applicationVersionUpdatedTo = applicationVersionUpdatedTo;
        }

        @Override
        public final Builder applicationVersionUpdatedTo(Long applicationVersionUpdatedTo) {
            this.applicationVersionUpdatedTo = applicationVersionUpdatedTo;
            return this;
        }

        @Override
        public ApplicationVersionChangeDetails build() {
            return new ApplicationVersionChangeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
