/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationDescription").getter(getter(CreateApplicationRequest::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build())
            .build();

    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeEnvironment").getter(getter(CreateApplicationRequest::runtimeEnvironmentAsString))
            .setter(setter(Builder::runtimeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRole").getter(getter(CreateApplicationRequest::serviceExecutionRole))
            .setter(setter(Builder::serviceExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build())
            .build();

    private static final SdkField<ApplicationConfiguration> APPLICATION_CONFIGURATION_FIELD = SdkField
            .<ApplicationConfiguration> builder(MarshallingType.SDK_POJO).memberName("ApplicationConfiguration")
            .getter(getter(CreateApplicationRequest::applicationConfiguration)).setter(setter(Builder::applicationConfiguration))
            .constructor(ApplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfiguration").build())
            .build();

    private static final SdkField<List<CloudWatchLoggingOption>> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<List<CloudWatchLoggingOption>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptions")
            .getter(getter(CreateApplicationRequest::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMode").getter(getter(CreateApplicationRequest::applicationModeAsString))
            .setter(setter(Builder::applicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            APPLICATION_DESCRIPTION_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD,
            APPLICATION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, TAGS_FIELD, APPLICATION_MODE_FIELD));

    private final String applicationName;

    private final String applicationDescription;

    private final String runtimeEnvironment;

    private final String serviceExecutionRole;

    private final ApplicationConfiguration applicationConfiguration;

    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

    private final List<Tag> tags;

    private final String applicationMode;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationConfiguration = builder.applicationConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.tags = builder.tags;
        this.applicationMode = builder.applicationMode;
    }

    /**
     * <p>
     * The name of your application (for example, <code>sample-app</code>).
     * </p>
     * 
     * @return The name of your application (for example, <code>sample-app</code>).
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * A summary description of the application.
     * </p>
     * 
     * @return A summary description of the application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The runtime environment for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application.
     * @see RuntimeEnvironment
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(runtimeEnvironment);
    }

    /**
     * <p>
     * The runtime environment for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runtimeEnvironment} will return {@link RuntimeEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #runtimeEnvironmentAsString}.
     * </p>
     * 
     * @return The runtime environment for the application.
     * @see RuntimeEnvironment
     */
    public final String runtimeEnvironmentAsString() {
        return runtimeEnvironment;
    }

    /**
     * <p>
     * The IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams,
     * Amazon S3 objects, and other external resources.
     * </p>
     * 
     * @return The IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery
     *         streams, Amazon S3 objects, and other external resources.
     */
    public final String serviceExecutionRole() {
        return serviceExecutionRole;
    }

    /**
     * <p>
     * Use this parameter to configure the application.
     * </p>
     * 
     * @return Use this parameter to configure the application.
     */
    public final ApplicationConfiguration applicationConfiguration() {
        return applicationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchLoggingOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions != null && !(cloudWatchLoggingOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchLoggingOptions} method.
     * </p>
     * 
     * @return Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration
     *         errors.
     */
    public final List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
     * application. Note that the maximum number of application tags includes system tags. The maximum number of
     * user-defined application tags is 50. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a Managed
     * Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a
     *         Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
     * @see ApplicationMode
     */
    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(applicationMode);
    }

    /**
     * <p>
     * Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a Managed
     * Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a
     *         Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
     * @see ApplicationMode
     */
    public final String applicationModeAsString() {
        return applicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchLoggingOptions() ? cloudWatchLoggingOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString())
                && Objects.equals(serviceExecutionRole(), other.serviceExecutionRole())
                && Objects.equals(applicationConfiguration(), other.applicationConfiguration())
                && hasCloudWatchLoggingOptions() == other.hasCloudWatchLoggingOptions()
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(applicationModeAsString(), other.applicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ApplicationName", applicationName())
                .add("ApplicationDescription", applicationDescription()).add("RuntimeEnvironment", runtimeEnvironmentAsString())
                .add("ServiceExecutionRole", serviceExecutionRole()).add("ApplicationConfiguration", applicationConfiguration())
                .add("CloudWatchLoggingOptions", hasCloudWatchLoggingOptions() ? cloudWatchLoggingOptions() : null)
                .add("Tags", hasTags() ? tags() : null).add("ApplicationMode", applicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironmentAsString()));
        case "ServiceExecutionRole":
            return Optional.ofNullable(clazz.cast(serviceExecutionRole()));
        case "ApplicationConfiguration":
            return Optional.ofNullable(clazz.cast(applicationConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ApplicationMode":
            return Optional.ofNullable(clazz.cast(applicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of your application (for example, <code>sample-app</code>).
         * </p>
         * 
         * @param applicationName
         *        The name of your application (for example, <code>sample-app</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * A summary description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        A summary description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The runtime environment for the application.
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application.
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(String runtimeEnvironment);

        /**
         * <p>
         * The runtime environment for the application.
         * </p>
         * 
         * @param runtimeEnvironment
         *        The runtime environment for the application.
         * @see RuntimeEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironment
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * The IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery streams,
         * Amazon S3 objects, and other external resources.
         * </p>
         * 
         * @param serviceExecutionRole
         *        The IAM role used by the application to access Kinesis data streams, Kinesis Data Firehose delivery
         *        streams, Amazon S3 objects, and other external resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRole(String serviceExecutionRole);

        /**
         * <p>
         * Use this parameter to configure the application.
         * </p>
         * 
         * @param applicationConfiguration
         *        Use this parameter to configure the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfiguration(ApplicationConfiguration applicationConfiguration);

        /**
         * <p>
         * Use this parameter to configure the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ApplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationConfiguration(ApplicationConfiguration)}.
         * 
         * @param applicationConfiguration
         *        a consumer that will call methods on {@link ApplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfiguration(ApplicationConfiguration)
         */
        default Builder applicationConfiguration(Consumer<ApplicationConfiguration.Builder> applicationConfiguration) {
            return applicationConfiguration(ApplicationConfiguration.builder().applyMutation(applicationConfiguration).build());
        }

        /**
         * <p>
         * Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration errors.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration
         *        errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration errors.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration
         *        errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure an Amazon CloudWatch log stream to monitor application configuration errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudWatchLoggingOptions(List<CloudWatchLoggingOption>)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(java.util.Collection<CloudWatchLoggingOption>)
         */
        Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder>... cloudWatchLoggingOptions);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
         * </p>
         * 
         * @param tags
         *        A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         *        application. Note that the maximum number of application tags includes system tags. The maximum number
         *        of user-defined application tags is 50. For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
         * </p>
         * 
         * @param tags
         *        A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         *        application. Note that the maximum number of application tags includes system tags. The maximum number
         *        of user-defined application tags is 50. For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a
         * Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
         * </p>
         * 
         * @param applicationMode
         *        Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To
         *        create a Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(String applicationMode);

        /**
         * <p>
         * Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To create a
         * Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
         * </p>
         * 
         * @param applicationMode
         *        Use the <code>STREAMING</code> mode to create a Managed Service for Apache Flink application. To
         *        create a Managed Service for Apache Flink Studio notebook, use the <code>INTERACTIVE</code> mode.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(ApplicationMode applicationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private String applicationDescription;

        private String runtimeEnvironment;

        private String serviceExecutionRole;

        private ApplicationConfiguration applicationConfiguration;

        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String applicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            applicationDescription(model.applicationDescription);
            runtimeEnvironment(model.runtimeEnvironment);
            serviceExecutionRole(model.serviceExecutionRole);
            applicationConfiguration(model.applicationConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            tags(model.tags);
            applicationMode(model.applicationMode);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final String getServiceExecutionRole() {
            return serviceExecutionRole;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final ApplicationConfiguration.Builder getApplicationConfiguration() {
            return applicationConfiguration != null ? applicationConfiguration.toBuilder() : null;
        }

        public final void setApplicationConfiguration(ApplicationConfiguration.BuilderImpl applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration != null ? applicationConfiguration.build() : null;
        }

        @Override
        public final Builder applicationConfiguration(ApplicationConfiguration applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        public final List<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            List<CloudWatchLoggingOption.Builder> result = CloudWatchLoggingOptionsCopier
                    .copyToBuilder(this.cloudWatchLoggingOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder>... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Stream.of(cloudWatchLoggingOptions)
                    .map(c -> CloudWatchLoggingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationMode() {
            return applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
