/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CustomArtifactsConfigurationDescriptionListCopier {
    static List<CustomArtifactConfigurationDescription> copy(
            Collection<? extends CustomArtifactConfigurationDescription> customArtifactsConfigurationDescriptionListParam) {
        List<CustomArtifactConfigurationDescription> list;
        if (customArtifactsConfigurationDescriptionListParam == null
                || customArtifactsConfigurationDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CustomArtifactConfigurationDescription> modifiableList = new ArrayList<>(
                    customArtifactsConfigurationDescriptionListParam.size());
            customArtifactsConfigurationDescriptionListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CustomArtifactConfigurationDescription> copyFromBuilder(
            Collection<? extends CustomArtifactConfigurationDescription.Builder> customArtifactsConfigurationDescriptionListParam) {
        List<CustomArtifactConfigurationDescription> list;
        if (customArtifactsConfigurationDescriptionListParam == null
                || customArtifactsConfigurationDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CustomArtifactConfigurationDescription> modifiableList = new ArrayList<>(
                    customArtifactsConfigurationDescriptionListParam.size());
            customArtifactsConfigurationDescriptionListParam.forEach(entry -> {
                CustomArtifactConfigurationDescription member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CustomArtifactConfigurationDescription.Builder> copyToBuilder(
            Collection<? extends CustomArtifactConfigurationDescription> customArtifactsConfigurationDescriptionListParam) {
        List<CustomArtifactConfigurationDescription.Builder> list;
        if (customArtifactsConfigurationDescriptionListParam == null
                || customArtifactsConfigurationDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CustomArtifactConfigurationDescription.Builder> modifiableList = new ArrayList<>(
                    customArtifactsConfigurationDescriptionListParam.size());
            customArtifactsConfigurationDescriptionListParam.forEach(entry -> {
                CustomArtifactConfigurationDescription.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
