/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<DescribeApplicationResponse.Builder, DescribeApplicationResponse> {
    private static final SdkField<ApplicationDetail> APPLICATION_DETAIL_FIELD = SdkField
            .<ApplicationDetail> builder(MarshallingType.SDK_POJO).memberName("ApplicationDetail")
            .getter(getter(DescribeApplicationResponse::applicationDetail)).setter(setter(Builder::applicationDetail))
            .constructor(ApplicationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_DETAIL_FIELD));

    private final ApplicationDetail applicationDetail;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationDetail = builder.applicationDetail;
    }

    /**
     * <p>
     * Provides a description of the application, such as the application's Amazon Resource Name (ARN), status, and
     * latest version.
     * </p>
     * 
     * @return Provides a description of the application, such as the application's Amazon Resource Name (ARN), status,
     *         and latest version.
     */
    public final ApplicationDetail applicationDetail() {
        return applicationDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse) obj;
        return Objects.equals(applicationDetail(), other.applicationDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationResponse").add("ApplicationDetail", applicationDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationDetail":
            return Optional.ofNullable(clazz.cast(applicationDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationResponse> {
        /**
         * <p>
         * Provides a description of the application, such as the application's Amazon Resource Name (ARN), status, and
         * latest version.
         * </p>
         * 
         * @param applicationDetail
         *        Provides a description of the application, such as the application's Amazon Resource Name (ARN),
         *        status, and latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDetail(ApplicationDetail applicationDetail);

        /**
         * <p>
         * Provides a description of the application, such as the application's Amazon Resource Name (ARN), status, and
         * latest version.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationDetail.Builder} avoiding the
         * need to create one manually via {@link ApplicationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationDetail(ApplicationDetail)}.
         * 
         * @param applicationDetail
         *        a consumer that will call methods on {@link ApplicationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationDetail(ApplicationDetail)
         */
        default Builder applicationDetail(Consumer<ApplicationDetail.Builder> applicationDetail) {
            return applicationDetail(ApplicationDetail.builder().applyMutation(applicationDetail).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private ApplicationDetail applicationDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            super(model);
            applicationDetail(model.applicationDetail);
        }

        public final ApplicationDetail.Builder getApplicationDetail() {
            return applicationDetail != null ? applicationDetail.toBuilder() : null;
        }

        public final void setApplicationDetail(ApplicationDetail.BuilderImpl applicationDetail) {
            this.applicationDetail = applicationDetail != null ? applicationDetail.build() : null;
        }

        @Override
        public final Builder applicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
            return this;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
