/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the configuration of the Glue Data Catalog that you use for SQL queries that you write in a Managed
 * Service for Apache Flink Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueDataCatalogConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueDataCatalogConfigurationUpdate.Builder, GlueDataCatalogConfigurationUpdate> {
    private static final SdkField<String> DATABASE_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseARNUpdate").getter(getter(GlueDataCatalogConfigurationUpdate::databaseARNUpdate))
            .setter(setter(Builder::databaseARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseARNUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ARN_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseARNUpdate;

    private GlueDataCatalogConfigurationUpdate(BuilderImpl builder) {
        this.databaseARNUpdate = builder.databaseARNUpdate;
    }

    /**
     * <p>
     * The updated Amazon Resource Name (ARN) of the database.
     * </p>
     * 
     * @return The updated Amazon Resource Name (ARN) of the database.
     */
    public final String databaseARNUpdate() {
        return databaseARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseARNUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueDataCatalogConfigurationUpdate)) {
            return false;
        }
        GlueDataCatalogConfigurationUpdate other = (GlueDataCatalogConfigurationUpdate) obj;
        return Objects.equals(databaseARNUpdate(), other.databaseARNUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueDataCatalogConfigurationUpdate").add("DatabaseARNUpdate", databaseARNUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseARNUpdate":
            return Optional.ofNullable(clazz.cast(databaseARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueDataCatalogConfigurationUpdate, T> g) {
        return obj -> g.apply((GlueDataCatalogConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueDataCatalogConfigurationUpdate> {
        /**
         * <p>
         * The updated Amazon Resource Name (ARN) of the database.
         * </p>
         * 
         * @param databaseARNUpdate
         *        The updated Amazon Resource Name (ARN) of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseARNUpdate(String databaseARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String databaseARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueDataCatalogConfigurationUpdate model) {
            databaseARNUpdate(model.databaseARNUpdate);
        }

        public final String getDatabaseARNUpdate() {
            return databaseARNUpdate;
        }

        public final void setDatabaseARNUpdate(String databaseARNUpdate) {
            this.databaseARNUpdate = databaseARNUpdate;
        }

        @Override
        public final Builder databaseARNUpdate(String databaseARNUpdate) {
            this.databaseARNUpdate = databaseARNUpdate;
            return this;
        }

        @Override
        public GlueDataCatalogConfigurationUpdate build() {
            return new GlueDataCatalogConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
