/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactsConfigurationDescriptionListCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZeppelinApplicationConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZeppelinApplicationConfigurationDescription> {
    private static final SdkField<ZeppelinMonitoringConfigurationDescription> MONITORING_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringConfigurationDescription").getter(ZeppelinApplicationConfigurationDescription.getter(ZeppelinApplicationConfigurationDescription::monitoringConfigurationDescription)).setter(ZeppelinApplicationConfigurationDescription.setter(Builder::monitoringConfigurationDescription)).constructor(ZeppelinMonitoringConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationDescription").build()}).build();
    private static final SdkField<CatalogConfigurationDescription> CATALOG_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogConfigurationDescription").getter(ZeppelinApplicationConfigurationDescription.getter(ZeppelinApplicationConfigurationDescription::catalogConfigurationDescription)).setter(ZeppelinApplicationConfigurationDescription.setter(Builder::catalogConfigurationDescription)).constructor(CatalogConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfigurationDescription").build()}).build();
    private static final SdkField<DeployAsApplicationConfigurationDescription> DEPLOY_AS_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeployAsApplicationConfigurationDescription").getter(ZeppelinApplicationConfigurationDescription.getter(ZeppelinApplicationConfigurationDescription::deployAsApplicationConfigurationDescription)).setter(ZeppelinApplicationConfigurationDescription.setter(Builder::deployAsApplicationConfigurationDescription)).constructor(DeployAsApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployAsApplicationConfigurationDescription").build()}).build();
    private static final SdkField<List<CustomArtifactConfigurationDescription>> CUSTOM_ARTIFACTS_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomArtifactsConfigurationDescription").getter(ZeppelinApplicationConfigurationDescription.getter(ZeppelinApplicationConfigurationDescription::customArtifactsConfigurationDescription)).setter(ZeppelinApplicationConfigurationDescription.setter(Builder::customArtifactsConfigurationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomArtifactsConfigurationDescription").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomArtifactConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_CONFIGURATION_DESCRIPTION_FIELD, CATALOG_CONFIGURATION_DESCRIPTION_FIELD, DEPLOY_AS_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CUSTOM_ARTIFACTS_CONFIGURATION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MonitoringConfigurationDescription", MONITORING_CONFIGURATION_DESCRIPTION_FIELD);
            this.put("CatalogConfigurationDescription", CATALOG_CONFIGURATION_DESCRIPTION_FIELD);
            this.put("DeployAsApplicationConfigurationDescription", DEPLOY_AS_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD);
            this.put("CustomArtifactsConfigurationDescription", CUSTOM_ARTIFACTS_CONFIGURATION_DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription;
    private final CatalogConfigurationDescription catalogConfigurationDescription;
    private final DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription;
    private final List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription;

    private ZeppelinApplicationConfigurationDescription(BuilderImpl builder) {
        this.monitoringConfigurationDescription = builder.monitoringConfigurationDescription;
        this.catalogConfigurationDescription = builder.catalogConfigurationDescription;
        this.deployAsApplicationConfigurationDescription = builder.deployAsApplicationConfigurationDescription;
        this.customArtifactsConfigurationDescription = builder.customArtifactsConfigurationDescription;
    }

    public final ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription() {
        return this.monitoringConfigurationDescription;
    }

    public final CatalogConfigurationDescription catalogConfigurationDescription() {
        return this.catalogConfigurationDescription;
    }

    public final DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription() {
        return this.deployAsApplicationConfigurationDescription;
    }

    public final boolean hasCustomArtifactsConfigurationDescription() {
        return this.customArtifactsConfigurationDescription != null && !(this.customArtifactsConfigurationDescription instanceof SdkAutoConstructList);
    }

    public final List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription() {
        return this.customArtifactsConfigurationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployAsApplicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomArtifactsConfigurationDescription() ? this.customArtifactsConfigurationDescription() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinApplicationConfigurationDescription)) {
            return false;
        }
        ZeppelinApplicationConfigurationDescription other = (ZeppelinApplicationConfigurationDescription)obj;
        return Objects.equals(this.monitoringConfigurationDescription(), other.monitoringConfigurationDescription()) && Objects.equals(this.catalogConfigurationDescription(), other.catalogConfigurationDescription()) && Objects.equals(this.deployAsApplicationConfigurationDescription(), other.deployAsApplicationConfigurationDescription()) && this.hasCustomArtifactsConfigurationDescription() == other.hasCustomArtifactsConfigurationDescription() && Objects.equals(this.customArtifactsConfigurationDescription(), other.customArtifactsConfigurationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ZeppelinApplicationConfigurationDescription").add("MonitoringConfigurationDescription", (Object)this.monitoringConfigurationDescription()).add("CatalogConfigurationDescription", (Object)this.catalogConfigurationDescription()).add("DeployAsApplicationConfigurationDescription", (Object)this.deployAsApplicationConfigurationDescription()).add("CustomArtifactsConfigurationDescription", this.hasCustomArtifactsConfigurationDescription() ? this.customArtifactsConfigurationDescription() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfigurationDescription()));
            }
            case "CatalogConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.catalogConfigurationDescription()));
            }
            case "DeployAsApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.deployAsApplicationConfigurationDescription()));
            }
            case "CustomArtifactsConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.customArtifactsConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ZeppelinApplicationConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription;
        private CatalogConfigurationDescription catalogConfigurationDescription;
        private DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription;
        private List<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinApplicationConfigurationDescription model) {
            this.monitoringConfigurationDescription(model.monitoringConfigurationDescription);
            this.catalogConfigurationDescription(model.catalogConfigurationDescription);
            this.deployAsApplicationConfigurationDescription(model.deployAsApplicationConfigurationDescription);
            this.customArtifactsConfigurationDescription(model.customArtifactsConfigurationDescription);
        }

        public final ZeppelinMonitoringConfigurationDescription.Builder getMonitoringConfigurationDescription() {
            return this.monitoringConfigurationDescription != null ? this.monitoringConfigurationDescription.toBuilder() : null;
        }

        public final void setMonitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription.BuilderImpl monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription != null ? monitoringConfigurationDescription.build() : null;
        }

        @Override
        public final Builder monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription monitoringConfigurationDescription) {
            this.monitoringConfigurationDescription = monitoringConfigurationDescription;
            return this;
        }

        public final CatalogConfigurationDescription.Builder getCatalogConfigurationDescription() {
            return this.catalogConfigurationDescription != null ? this.catalogConfigurationDescription.toBuilder() : null;
        }

        public final void setCatalogConfigurationDescription(CatalogConfigurationDescription.BuilderImpl catalogConfigurationDescription) {
            this.catalogConfigurationDescription = catalogConfigurationDescription != null ? catalogConfigurationDescription.build() : null;
        }

        @Override
        public final Builder catalogConfigurationDescription(CatalogConfigurationDescription catalogConfigurationDescription) {
            this.catalogConfigurationDescription = catalogConfigurationDescription;
            return this;
        }

        public final DeployAsApplicationConfigurationDescription.Builder getDeployAsApplicationConfigurationDescription() {
            return this.deployAsApplicationConfigurationDescription != null ? this.deployAsApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setDeployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription.BuilderImpl deployAsApplicationConfigurationDescription) {
            this.deployAsApplicationConfigurationDescription = deployAsApplicationConfigurationDescription != null ? deployAsApplicationConfigurationDescription.build() : null;
        }

        @Override
        public final Builder deployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription deployAsApplicationConfigurationDescription) {
            this.deployAsApplicationConfigurationDescription = deployAsApplicationConfigurationDescription;
            return this;
        }

        public final List<CustomArtifactConfigurationDescription.Builder> getCustomArtifactsConfigurationDescription() {
            List<CustomArtifactConfigurationDescription.Builder> result = CustomArtifactsConfigurationDescriptionListCopier.copyToBuilder(this.customArtifactsConfigurationDescription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomArtifactsConfigurationDescription(Collection<CustomArtifactConfigurationDescription.BuilderImpl> customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription = CustomArtifactsConfigurationDescriptionListCopier.copyFromBuilder(customArtifactsConfigurationDescription);
        }

        @Override
        public final Builder customArtifactsConfigurationDescription(Collection<CustomArtifactConfigurationDescription> customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription = CustomArtifactsConfigurationDescriptionListCopier.copy(customArtifactsConfigurationDescription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationDescription(CustomArtifactConfigurationDescription ... customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription(Arrays.asList(customArtifactsConfigurationDescription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfigurationDescription(Consumer<CustomArtifactConfigurationDescription.Builder> ... customArtifactsConfigurationDescription) {
            this.customArtifactsConfigurationDescription(Stream.of(customArtifactsConfigurationDescription).map(c -> (CustomArtifactConfigurationDescription)((CustomArtifactConfigurationDescription.Builder)CustomArtifactConfigurationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ZeppelinApplicationConfigurationDescription build() {
            return new ZeppelinApplicationConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZeppelinApplicationConfigurationDescription> {
        public Builder monitoringConfigurationDescription(ZeppelinMonitoringConfigurationDescription var1);

        default public Builder monitoringConfigurationDescription(Consumer<ZeppelinMonitoringConfigurationDescription.Builder> monitoringConfigurationDescription) {
            return this.monitoringConfigurationDescription((ZeppelinMonitoringConfigurationDescription)((ZeppelinMonitoringConfigurationDescription.Builder)ZeppelinMonitoringConfigurationDescription.builder().applyMutation(monitoringConfigurationDescription)).build());
        }

        public Builder catalogConfigurationDescription(CatalogConfigurationDescription var1);

        default public Builder catalogConfigurationDescription(Consumer<CatalogConfigurationDescription.Builder> catalogConfigurationDescription) {
            return this.catalogConfigurationDescription((CatalogConfigurationDescription)((CatalogConfigurationDescription.Builder)CatalogConfigurationDescription.builder().applyMutation(catalogConfigurationDescription)).build());
        }

        public Builder deployAsApplicationConfigurationDescription(DeployAsApplicationConfigurationDescription var1);

        default public Builder deployAsApplicationConfigurationDescription(Consumer<DeployAsApplicationConfigurationDescription.Builder> deployAsApplicationConfigurationDescription) {
            return this.deployAsApplicationConfigurationDescription((DeployAsApplicationConfigurationDescription)((DeployAsApplicationConfigurationDescription.Builder)DeployAsApplicationConfigurationDescription.builder().applyMutation(deployAsApplicationConfigurationDescription)).build());
        }

        public Builder customArtifactsConfigurationDescription(Collection<CustomArtifactConfigurationDescription> var1);

        public Builder customArtifactsConfigurationDescription(CustomArtifactConfigurationDescription ... var1);

        public Builder customArtifactsConfigurationDescription(Consumer<CustomArtifactConfigurationDescription.Builder> ... var1);
    }
}

