/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummariesCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationVersionsResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, ListApplicationVersionsResponse> {
    private static final SdkField<List<ApplicationVersionSummary>> APPLICATION_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationVersionSummaries").getter(ListApplicationVersionsResponse.getter(ListApplicationVersionsResponse::applicationVersionSummaries)).setter(ListApplicationVersionsResponse.setter(Builder::applicationVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationVersionsResponse.getter(ListApplicationVersionsResponse::nextToken)).setter(ListApplicationVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationVersionsResponse.memberNameToFieldInitializer();
    private final List<ApplicationVersionSummary> applicationVersionSummaries;
    private final String nextToken;

    private ListApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersionSummaries = builder.applicationVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationVersionSummaries() {
        return this.applicationVersionSummaries != null && !(this.applicationVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ApplicationVersionSummary> applicationVersionSummaries() {
        return this.applicationVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationVersionSummaries() ? this.applicationVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResponse)) {
            return false;
        }
        ListApplicationVersionsResponse other = (ListApplicationVersionsResponse)((Object)obj);
        return this.hasApplicationVersionSummaries() == other.hasApplicationVersionSummaries() && Objects.equals(this.applicationVersionSummaries(), other.applicationVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationVersionsResponse").add("ApplicationVersionSummaries", this.hasApplicationVersionSummaries() ? this.applicationVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationVersionSummaries", APPLICATION_VERSION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationVersionsResponse, T> g) {
        return obj -> g.apply((ListApplicationVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private List<ApplicationVersionSummary> applicationVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationVersionsResponse model) {
            super(model);
            this.applicationVersionSummaries(model.applicationVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationVersionSummary.Builder> getApplicationVersionSummaries() {
            List<ApplicationVersionSummary.Builder> result = ApplicationVersionSummariesCopier.copyToBuilder(this.applicationVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationVersionSummaries(Collection<ApplicationVersionSummary.BuilderImpl> applicationVersionSummaries) {
            this.applicationVersionSummaries = ApplicationVersionSummariesCopier.copyFromBuilder(applicationVersionSummaries);
        }

        @Override
        public final Builder applicationVersionSummaries(Collection<ApplicationVersionSummary> applicationVersionSummaries) {
            this.applicationVersionSummaries = ApplicationVersionSummariesCopier.copy(applicationVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersionSummaries(ApplicationVersionSummary ... applicationVersionSummaries) {
            this.applicationVersionSummaries(Arrays.asList(applicationVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersionSummaries(Consumer<ApplicationVersionSummary.Builder> ... applicationVersionSummaries) {
            this.applicationVersionSummaries(Stream.of(applicationVersionSummaries).map(c -> (ApplicationVersionSummary)((ApplicationVersionSummary.Builder)ApplicationVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationVersionsResponse build() {
            return new ListApplicationVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationVersionsResponse> {
        public Builder applicationVersionSummaries(Collection<ApplicationVersionSummary> var1);

        public Builder applicationVersionSummaries(ApplicationVersionSummary ... var1);

        public Builder applicationVersionSummaries(Consumer<ApplicationVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

