/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse;

public class ListApplicationVersionsPublisher
implements SdkPublisher<ListApplicationVersionsResponse> {
    private final KinesisAnalyticsV2AsyncClient client;
    private final ListApplicationVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationVersionsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationVersionsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationVersionSummary> applicationVersionSummaries() {
        Function<ListApplicationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationVersionSummaries() != null) {
                return response.applicationVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationVersionsResponseFetcher
    implements AsyncPageFetcher<ListApplicationVersionsResponse> {
        private ListApplicationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationVersionsResponse> nextPage(ListApplicationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationVersionsPublisher.this.client.listApplicationVersions(ListApplicationVersionsPublisher.this.firstRequest);
            }
            return ListApplicationVersionsPublisher.this.client.listApplicationVersions((ListApplicationVersionsRequest)((Object)ListApplicationVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

