/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationDetail> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(ApplicationDetail.getter(ApplicationDetail::applicationARN)).setter(ApplicationDetail.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationDescription").getter(ApplicationDetail.getter(ApplicationDetail::applicationDescription)).setter(ApplicationDetail.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ApplicationDetail.getter(ApplicationDetail::applicationName)).setter(ApplicationDetail.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeEnvironment").getter(ApplicationDetail.getter(ApplicationDetail::runtimeEnvironmentAsString)).setter(ApplicationDetail.setter(Builder::runtimeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceExecutionRole").getter(ApplicationDetail.getter(ApplicationDetail::serviceExecutionRole)).setter(ApplicationDetail.setter(Builder::serviceExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceExecutionRole").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationStatus").getter(ApplicationDetail.getter(ApplicationDetail::applicationStatusAsString)).setter(ApplicationDetail.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionId)).setter(ApplicationDetail.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTimestamp").getter(ApplicationDetail.getter(ApplicationDetail::createTimestamp)).setter(ApplicationDetail.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(ApplicationDetail.getter(ApplicationDetail::lastUpdateTimestamp)).setter(ApplicationDetail.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<ApplicationConfigurationDescription> APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationConfigurationDescription").getter(ApplicationDetail.getter(ApplicationDetail::applicationConfigurationDescription)).setter(ApplicationDetail.setter(Builder::applicationConfigurationDescription)).constructor(ApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfigurationDescription").build()}).build();
    private static final SdkField<List<CloudWatchLoggingOptionDescription>> CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchLoggingOptionDescriptions").getter(ApplicationDetail.getter(ApplicationDetail::cloudWatchLoggingOptionDescriptions)).setter(ApplicationDetail.setter(Builder::cloudWatchLoggingOptionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLoggingOptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationMaintenanceConfigurationDescription> APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationMaintenanceConfigurationDescription").getter(ApplicationDetail.getter(ApplicationDetail::applicationMaintenanceConfigurationDescription)).setter(ApplicationDetail.setter(Builder::applicationMaintenanceConfigurationDescription)).constructor(ApplicationMaintenanceConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMaintenanceConfigurationDescription").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_UPDATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionUpdatedFrom").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionUpdatedFrom)).setter(ApplicationDetail.setter(Builder::applicationVersionUpdatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionUpdatedFrom").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ROLLED_BACK_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionRolledBackFrom").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionRolledBackFrom)).setter(ApplicationDetail.setter(Builder::applicationVersionRolledBackFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionRolledBackFrom").build()}).build();
    private static final SdkField<Instant> APPLICATION_VERSION_CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApplicationVersionCreateTimestamp").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionCreateTimestamp)).setter(ApplicationDetail.setter(Builder::applicationVersionCreateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionCreateTimestamp").build()}).build();
    private static final SdkField<String> CONDITIONAL_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionalToken").getter(ApplicationDetail.getter(ApplicationDetail::conditionalToken)).setter(ApplicationDetail.setter(Builder::conditionalToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalToken").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ROLLED_BACK_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionRolledBackTo").getter(ApplicationDetail.getter(ApplicationDetail::applicationVersionRolledBackTo)).setter(ApplicationDetail.setter(Builder::applicationVersionRolledBackTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionRolledBackTo").build()}).build();
    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationMode").getter(ApplicationDetail.getter(ApplicationDetail::applicationModeAsString)).setter(ApplicationDetail.setter(Builder::applicationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_NAME_FIELD, RUNTIME_ENVIRONMENT_FIELD, SERVICE_EXECUTION_ROLE_FIELD, APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD, APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD, APPLICATION_VERSION_UPDATED_FROM_FIELD, APPLICATION_VERSION_ROLLED_BACK_FROM_FIELD, APPLICATION_VERSION_CREATE_TIMESTAMP_FIELD, CONDITIONAL_TOKEN_FIELD, APPLICATION_VERSION_ROLLED_BACK_TO_FIELD, APPLICATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationARN;
    private final String applicationDescription;
    private final String applicationName;
    private final String runtimeEnvironment;
    private final String serviceExecutionRole;
    private final String applicationStatus;
    private final Long applicationVersionId;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final ApplicationConfigurationDescription applicationConfigurationDescription;
    private final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions;
    private final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;
    private final Long applicationVersionUpdatedFrom;
    private final Long applicationVersionRolledBackFrom;
    private final Instant applicationVersionCreateTimestamp;
    private final String conditionalToken;
    private final Long applicationVersionRolledBackTo;
    private final String applicationMode;

    private ApplicationDetail(BuilderImpl builder) {
        this.applicationARN = builder.applicationARN;
        this.applicationDescription = builder.applicationDescription;
        this.applicationName = builder.applicationName;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.serviceExecutionRole = builder.serviceExecutionRole;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.applicationConfigurationDescription = builder.applicationConfigurationDescription;
        this.cloudWatchLoggingOptionDescriptions = builder.cloudWatchLoggingOptionDescriptions;
        this.applicationMaintenanceConfigurationDescription = builder.applicationMaintenanceConfigurationDescription;
        this.applicationVersionUpdatedFrom = builder.applicationVersionUpdatedFrom;
        this.applicationVersionRolledBackFrom = builder.applicationVersionRolledBackFrom;
        this.applicationVersionCreateTimestamp = builder.applicationVersionCreateTimestamp;
        this.conditionalToken = builder.conditionalToken;
        this.applicationVersionRolledBackTo = builder.applicationVersionRolledBackTo;
        this.applicationMode = builder.applicationMode;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final String applicationDescription() {
        return this.applicationDescription;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(this.runtimeEnvironment);
    }

    public final String runtimeEnvironmentAsString() {
        return this.runtimeEnvironment;
    }

    public final String serviceExecutionRole() {
        return this.serviceExecutionRole;
    }

    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public final String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final Instant createTimestamp() {
        return this.createTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final ApplicationConfigurationDescription applicationConfigurationDescription() {
        return this.applicationConfigurationDescription;
    }

    public final boolean hasCloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions != null && !(this.cloudWatchLoggingOptionDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions() {
        return this.cloudWatchLoggingOptionDescriptions;
    }

    public final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription() {
        return this.applicationMaintenanceConfigurationDescription;
    }

    public final Long applicationVersionUpdatedFrom() {
        return this.applicationVersionUpdatedFrom;
    }

    public final Long applicationVersionRolledBackFrom() {
        return this.applicationVersionRolledBackFrom;
    }

    public final Instant applicationVersionCreateTimestamp() {
        return this.applicationVersionCreateTimestamp;
    }

    public final String conditionalToken() {
        return this.conditionalToken;
    }

    public final Long applicationVersionRolledBackTo() {
        return this.applicationVersionRolledBackTo;
    }

    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(this.applicationMode);
    }

    public final String applicationModeAsString() {
        return this.applicationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchLoggingOptionDescriptions() ? this.cloudWatchLoggingOptionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMaintenanceConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionUpdatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionRolledBackFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionCreateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionRolledBackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDetail)) {
            return false;
        }
        ApplicationDetail other = (ApplicationDetail)obj;
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString()) && Objects.equals(this.serviceExecutionRole(), other.serviceExecutionRole()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.applicationConfigurationDescription(), other.applicationConfigurationDescription()) && this.hasCloudWatchLoggingOptionDescriptions() == other.hasCloudWatchLoggingOptionDescriptions() && Objects.equals(this.cloudWatchLoggingOptionDescriptions(), other.cloudWatchLoggingOptionDescriptions()) && Objects.equals(this.applicationMaintenanceConfigurationDescription(), other.applicationMaintenanceConfigurationDescription()) && Objects.equals(this.applicationVersionUpdatedFrom(), other.applicationVersionUpdatedFrom()) && Objects.equals(this.applicationVersionRolledBackFrom(), other.applicationVersionRolledBackFrom()) && Objects.equals(this.applicationVersionCreateTimestamp(), other.applicationVersionCreateTimestamp()) && Objects.equals(this.conditionalToken(), other.conditionalToken()) && Objects.equals(this.applicationVersionRolledBackTo(), other.applicationVersionRolledBackTo()) && Objects.equals(this.applicationModeAsString(), other.applicationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationDetail").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationName", (Object)this.applicationName()).add("RuntimeEnvironment", (Object)this.runtimeEnvironmentAsString()).add("ServiceExecutionRole", (Object)this.serviceExecutionRole()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("ApplicationConfigurationDescription", (Object)this.applicationConfigurationDescription()).add("CloudWatchLoggingOptionDescriptions", this.hasCloudWatchLoggingOptionDescriptions() ? this.cloudWatchLoggingOptionDescriptions() : null).add("ApplicationMaintenanceConfigurationDescription", (Object)this.applicationMaintenanceConfigurationDescription()).add("ApplicationVersionUpdatedFrom", (Object)this.applicationVersionUpdatedFrom()).add("ApplicationVersionRolledBackFrom", (Object)this.applicationVersionRolledBackFrom()).add("ApplicationVersionCreateTimestamp", (Object)this.applicationVersionCreateTimestamp()).add("ConditionalToken", (Object)this.conditionalToken()).add("ApplicationVersionRolledBackTo", (Object)this.applicationVersionRolledBackTo()).add("ApplicationMode", (Object)this.applicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentAsString()));
            }
            case "ServiceExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRole()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "ApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationDescription()));
            }
            case "CloudWatchLoggingOptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionDescriptions()));
            }
            case "ApplicationMaintenanceConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationMaintenanceConfigurationDescription()));
            }
            case "ApplicationVersionUpdatedFrom": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionUpdatedFrom()));
            }
            case "ApplicationVersionRolledBackFrom": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionRolledBackFrom()));
            }
            case "ApplicationVersionCreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionCreateTimestamp()));
            }
            case "ConditionalToken": {
                return Optional.ofNullable(clazz.cast(this.conditionalToken()));
            }
            case "ApplicationVersionRolledBackTo": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionRolledBackTo()));
            }
            case "ApplicationMode": {
                return Optional.ofNullable(clazz.cast(this.applicationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationDescription", APPLICATION_DESCRIPTION_FIELD);
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("ServiceExecutionRole", SERVICE_EXECUTION_ROLE_FIELD);
        map.put("ApplicationStatus", APPLICATION_STATUS_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("ApplicationConfigurationDescription", APPLICATION_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("CloudWatchLoggingOptionDescriptions", CLOUD_WATCH_LOGGING_OPTION_DESCRIPTIONS_FIELD);
        map.put("ApplicationMaintenanceConfigurationDescription", APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("ApplicationVersionUpdatedFrom", APPLICATION_VERSION_UPDATED_FROM_FIELD);
        map.put("ApplicationVersionRolledBackFrom", APPLICATION_VERSION_ROLLED_BACK_FROM_FIELD);
        map.put("ApplicationVersionCreateTimestamp", APPLICATION_VERSION_CREATE_TIMESTAMP_FIELD);
        map.put("ConditionalToken", CONDITIONAL_TOKEN_FIELD);
        map.put("ApplicationVersionRolledBackTo", APPLICATION_VERSION_ROLLED_BACK_TO_FIELD);
        map.put("ApplicationMode", APPLICATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDetail, T> g) {
        return obj -> g.apply((ApplicationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationARN;
        private String applicationDescription;
        private String applicationName;
        private String runtimeEnvironment;
        private String serviceExecutionRole;
        private String applicationStatus;
        private Long applicationVersionId;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private ApplicationConfigurationDescription applicationConfigurationDescription;
        private List<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;
        private Long applicationVersionUpdatedFrom;
        private Long applicationVersionRolledBackFrom;
        private Instant applicationVersionCreateTimestamp;
        private String conditionalToken;
        private Long applicationVersionRolledBackTo;
        private String applicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDetail model) {
            this.applicationARN(model.applicationARN);
            this.applicationDescription(model.applicationDescription);
            this.applicationName(model.applicationName);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.serviceExecutionRole(model.serviceExecutionRole);
            this.applicationStatus(model.applicationStatus);
            this.applicationVersionId(model.applicationVersionId);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.applicationConfigurationDescription(model.applicationConfigurationDescription);
            this.cloudWatchLoggingOptionDescriptions(model.cloudWatchLoggingOptionDescriptions);
            this.applicationMaintenanceConfigurationDescription(model.applicationMaintenanceConfigurationDescription);
            this.applicationVersionUpdatedFrom(model.applicationVersionUpdatedFrom);
            this.applicationVersionRolledBackFrom(model.applicationVersionRolledBackFrom);
            this.applicationVersionCreateTimestamp(model.applicationVersionCreateTimestamp);
            this.conditionalToken(model.conditionalToken);
            this.applicationVersionRolledBackTo(model.applicationVersionRolledBackTo);
            this.applicationMode(model.applicationMode);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        public final void setServiceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
        }

        @Override
        public final Builder serviceExecutionRole(String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final ApplicationConfigurationDescription.Builder getApplicationConfigurationDescription() {
            return this.applicationConfigurationDescription != null ? this.applicationConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationConfigurationDescription(ApplicationConfigurationDescription.BuilderImpl applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription != null ? applicationConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationConfigurationDescription(ApplicationConfigurationDescription applicationConfigurationDescription) {
            this.applicationConfigurationDescription = applicationConfigurationDescription;
            return this;
        }

        public final List<CloudWatchLoggingOptionDescription.Builder> getCloudWatchLoggingOptionDescriptions() {
            List<CloudWatchLoggingOptionDescription.Builder> result = CloudWatchLoggingOptionDescriptionsCopier.copyToBuilder(this.cloudWatchLoggingOptionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription.BuilderImpl> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copyFromBuilder(cloudWatchLoggingOptionDescriptions);
        }

        @Override
        public final Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions = CloudWatchLoggingOptionDescriptionsCopier.copy(cloudWatchLoggingOptionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Arrays.asList(cloudWatchLoggingOptionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... cloudWatchLoggingOptionDescriptions) {
            this.cloudWatchLoggingOptionDescriptions(Stream.of(cloudWatchLoggingOptionDescriptions).map(c -> (CloudWatchLoggingOptionDescription)((CloudWatchLoggingOptionDescription.Builder)CloudWatchLoggingOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationMaintenanceConfigurationDescription.Builder getApplicationMaintenanceConfigurationDescription() {
            return this.applicationMaintenanceConfigurationDescription != null ? this.applicationMaintenanceConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription.BuilderImpl applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription;
            return this;
        }

        public final Long getApplicationVersionUpdatedFrom() {
            return this.applicationVersionUpdatedFrom;
        }

        public final void setApplicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
        }

        @Override
        public final Builder applicationVersionUpdatedFrom(Long applicationVersionUpdatedFrom) {
            this.applicationVersionUpdatedFrom = applicationVersionUpdatedFrom;
            return this;
        }

        public final Long getApplicationVersionRolledBackFrom() {
            return this.applicationVersionRolledBackFrom;
        }

        public final void setApplicationVersionRolledBackFrom(Long applicationVersionRolledBackFrom) {
            this.applicationVersionRolledBackFrom = applicationVersionRolledBackFrom;
        }

        @Override
        public final Builder applicationVersionRolledBackFrom(Long applicationVersionRolledBackFrom) {
            this.applicationVersionRolledBackFrom = applicationVersionRolledBackFrom;
            return this;
        }

        public final Instant getApplicationVersionCreateTimestamp() {
            return this.applicationVersionCreateTimestamp;
        }

        public final void setApplicationVersionCreateTimestamp(Instant applicationVersionCreateTimestamp) {
            this.applicationVersionCreateTimestamp = applicationVersionCreateTimestamp;
        }

        @Override
        public final Builder applicationVersionCreateTimestamp(Instant applicationVersionCreateTimestamp) {
            this.applicationVersionCreateTimestamp = applicationVersionCreateTimestamp;
            return this;
        }

        public final String getConditionalToken() {
            return this.conditionalToken;
        }

        public final void setConditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
        }

        @Override
        public final Builder conditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
            return this;
        }

        public final Long getApplicationVersionRolledBackTo() {
            return this.applicationVersionRolledBackTo;
        }

        public final void setApplicationVersionRolledBackTo(Long applicationVersionRolledBackTo) {
            this.applicationVersionRolledBackTo = applicationVersionRolledBackTo;
        }

        @Override
        public final Builder applicationVersionRolledBackTo(Long applicationVersionRolledBackTo) {
            this.applicationVersionRolledBackTo = applicationVersionRolledBackTo;
            return this;
        }

        public final String getApplicationMode() {
            return this.applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        public ApplicationDetail build() {
            return new ApplicationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationDetail> {
        public Builder applicationARN(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationName(String var1);

        public Builder runtimeEnvironment(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        public Builder serviceExecutionRole(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder applicationVersionId(Long var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder applicationConfigurationDescription(ApplicationConfigurationDescription var1);

        default public Builder applicationConfigurationDescription(Consumer<ApplicationConfigurationDescription.Builder> applicationConfigurationDescription) {
            return this.applicationConfigurationDescription((ApplicationConfigurationDescription)((ApplicationConfigurationDescription.Builder)ApplicationConfigurationDescription.builder().applyMutation(applicationConfigurationDescription)).build());
        }

        public Builder cloudWatchLoggingOptionDescriptions(Collection<CloudWatchLoggingOptionDescription> var1);

        public Builder cloudWatchLoggingOptionDescriptions(CloudWatchLoggingOptionDescription ... var1);

        public Builder cloudWatchLoggingOptionDescriptions(Consumer<CloudWatchLoggingOptionDescription.Builder> ... var1);

        public Builder applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription var1);

        default public Builder applicationMaintenanceConfigurationDescription(Consumer<ApplicationMaintenanceConfigurationDescription.Builder> applicationMaintenanceConfigurationDescription) {
            return this.applicationMaintenanceConfigurationDescription((ApplicationMaintenanceConfigurationDescription)((ApplicationMaintenanceConfigurationDescription.Builder)ApplicationMaintenanceConfigurationDescription.builder().applyMutation(applicationMaintenanceConfigurationDescription)).build());
        }

        public Builder applicationVersionUpdatedFrom(Long var1);

        public Builder applicationVersionRolledBackFrom(Long var1);

        public Builder applicationVersionCreateTimestamp(Instant var1);

        public Builder conditionalToken(String var1);

        public Builder applicationVersionRolledBackTo(Long var1);

        public Builder applicationMode(String var1);

        public Builder applicationMode(ApplicationMode var1);
    }
}

