/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingOptionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLoggingOptionDescription> {
    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLoggingOptionId").getter(CloudWatchLoggingOptionDescription.getter(CloudWatchLoggingOptionDescription::cloudWatchLoggingOptionId)).setter(CloudWatchLoggingOptionDescription.setter(Builder::cloudWatchLoggingOptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build()}).build();
    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStreamARN").getter(CloudWatchLoggingOptionDescription.getter(CloudWatchLoggingOptionDescription::logStreamARN)).setter(CloudWatchLoggingOptionDescription.setter(Builder::logStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CloudWatchLoggingOptionDescription.getter(CloudWatchLoggingOptionDescription::roleARN)).setter(CloudWatchLoggingOptionDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGGING_OPTION_ID_FIELD, LOG_STREAM_ARN_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchLoggingOptionDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLoggingOptionId;
    private final String logStreamARN;
    private final String roleARN;

    private CloudWatchLoggingOptionDescription(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    public final String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    public final String logStreamARN() {
        return this.logStreamARN;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionDescription)) {
            return false;
        }
        CloudWatchLoggingOptionDescription other = (CloudWatchLoggingOptionDescription)obj;
        return Objects.equals(this.cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId()) && Objects.equals(this.logStreamARN(), other.logStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLoggingOptionDescription").add("CloudWatchLoggingOptionId", (Object)this.cloudWatchLoggingOptionId()).add("LogStreamARN", (Object)this.logStreamARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLoggingOptionId": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionId()));
            }
            case "LogStreamARN": {
                return Optional.ofNullable(clazz.cast(this.logStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CloudWatchLoggingOptionId", CLOUD_WATCH_LOGGING_OPTION_ID_FIELD);
        map.put("LogStreamARN", LOG_STREAM_ARN_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOptionDescription, T> g) {
        return obj -> g.apply((CloudWatchLoggingOptionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLoggingOptionId;
        private String logStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionDescription model) {
            this.cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            this.logStreamARN(model.logStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final String getLogStreamARN() {
            return this.logStreamARN;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public CloudWatchLoggingOptionDescription build() {
            return new CloudWatchLoggingOptionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLoggingOptionDescription> {
        public Builder cloudWatchLoggingOptionId(String var1);

        public Builder logStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

