/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationEncryptionConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationEncryptionConfigurationDescription> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(ApplicationEncryptionConfigurationDescription.getter(ApplicationEncryptionConfigurationDescription::keyId)).setter(ApplicationEncryptionConfigurationDescription.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(ApplicationEncryptionConfigurationDescription.getter(ApplicationEncryptionConfigurationDescription::keyTypeAsString)).setter(ApplicationEncryptionConfigurationDescription.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, KEY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationEncryptionConfigurationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String keyType;

    private ApplicationEncryptionConfigurationDescription(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyType = builder.keyType;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationEncryptionConfigurationDescription)) {
            return false;
        }
        ApplicationEncryptionConfigurationDescription other = (ApplicationEncryptionConfigurationDescription)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationEncryptionConfigurationDescription").add("KeyId", (Object)this.keyId()).add("KeyType", (Object)this.keyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("KeyType", KEY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationEncryptionConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationEncryptionConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationEncryptionConfigurationDescription model) {
            this.keyId(model.keyId);
            this.keyType(model.keyType);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public ApplicationEncryptionConfigurationDescription build() {
            return new ApplicationEncryptionConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationEncryptionConfigurationDescription> {
        public Builder keyId(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);
    }
}

