/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2ServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.KinesisAnalyticsV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeValidationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationOperationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationOperationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidApplicationConfigurationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidRequestException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LimitExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TooManyTagsException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnableToDetectSchemaException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationInputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.AddApplicationVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationPresignedUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.CreateApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DeleteApplicationVpcConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationOperationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationSnapshotRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DescribeApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.DiscoverInputSchemaRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationOperationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationVersionsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.RollbackApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StartApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.StopApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UpdateApplicationMaintenanceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalyticsv2.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKinesisAnalyticsV2AsyncClient
implements KinesisAnalyticsV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisAnalyticsV2AsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisAnalyticsV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Kinesis_Analytics_V2#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddApplicationCloudWatchLoggingOptionResponse> addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationCloudWatchLoggingOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationCloudWatchLoggingOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationCloudWatchLoggingOptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationCloudWatchLoggingOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationCloudWatchLoggingOptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationCloudWatchLoggingOption$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationCloudWatchLoggingOption$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationInputResponse> addApplicationInput(AddApplicationInputRequest addApplicationInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationInput$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationInput$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationInputProcessingConfigurationResponse> addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationInputProcessingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInputProcessingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputProcessingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInputProcessingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationInputProcessingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationInputProcessingConfiguration$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationInputProcessingConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationOutputResponse> addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationOutput$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationOutput$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationReferenceDataSourceResponse> addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationReferenceDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationReferenceDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationReferenceDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationReferenceDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationReferenceDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationReferenceDataSource$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationReferenceDataSource$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationVpcConfigurationResponse> addApplicationVpcConfiguration(AddApplicationVpcConfigurationRequest addApplicationVpcConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationVpcConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationVpcConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationVpcConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationVpcConfiguration$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$addApplicationVpcConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplication$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplication$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationPresignedUrlResponse> createApplicationPresignedUrl(CreateApplicationPresignedUrlRequest createApplicationPresignedUrlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationPresignedUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, createApplicationPresignedUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationPresignedUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationPresignedUrlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationPresignedUrl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApplicationPresignedUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApplicationPresignedUrlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplicationPresignedUrl$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplicationPresignedUrl$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationSnapshotResponse> createApplicationSnapshot(CreateApplicationSnapshotRequest createApplicationSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, createApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApplicationSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplicationSnapshot$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$createApplicationSnapshot$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplication$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplication$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationCloudWatchLoggingOptionResponse> deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationCloudWatchLoggingOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationCloudWatchLoggingOptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationCloudWatchLoggingOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationCloudWatchLoggingOption$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationCloudWatchLoggingOption$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationInputProcessingConfigurationResponse> deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationInputProcessingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationInputProcessingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationInputProcessingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationInputProcessingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationInputProcessingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationInputProcessingConfiguration$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationInputProcessingConfiguration$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationOutputResponse> deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationOutput$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationOutput$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationReferenceDataSourceResponse> deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationReferenceDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationReferenceDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationReferenceDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationReferenceDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationReferenceDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationReferenceDataSource$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationReferenceDataSource$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationSnapshotResponse> deleteApplicationSnapshot(DeleteApplicationSnapshotRequest deleteApplicationSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationSnapshot$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationSnapshot$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationVpcConfigurationResponse> deleteApplicationVpcConfiguration(DeleteApplicationVpcConfigurationRequest deleteApplicationVpcConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationVpcConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationVpcConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationVpcConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationVpcConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationVpcConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationVpcConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationVpcConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationVpcConfiguration$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$deleteApplicationVpcConfiguration$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationResponse> describeApplication(DescribeApplicationRequest describeApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplication$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplication$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationOperationResponse> describeApplicationOperation(DescribeApplicationOperationRequest describeApplicationOperationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeApplicationOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationOperationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeApplicationOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeApplicationOperationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationOperation$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationOperation$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationSnapshotResponse> describeApplicationSnapshot(DescribeApplicationSnapshotRequest describeApplicationSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeApplicationSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeApplicationSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeApplicationSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationSnapshot$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationSnapshot$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationVersionResponse> describeApplicationVersion(DescribeApplicationVersionRequest describeApplicationVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeApplicationVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeApplicationVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeApplicationVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationVersion$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$describeApplicationVersion$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DiscoverInputSchemaResponse> discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInputSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, discoverInputSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInputSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInputSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInputSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DiscoverInputSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)discoverInputSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$discoverInputSchema$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$discoverInputSchema$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationOperationsResponse> listApplicationOperations(ListApplicationOperationsRequest listApplicationOperationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApplicationOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApplicationOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationOperations$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationOperations$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationSnapshotsResponse> listApplicationSnapshots(ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApplicationSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApplicationSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationSnapshots$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationSnapshots$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(ListApplicationVersionsRequest listApplicationVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApplicationVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApplicationVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationVersions$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplicationVersions$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApplicationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplications$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listApplications$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listTagsForResource$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$listTagsForResource$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RollbackApplicationResponse> rollbackApplication(RollbackApplicationRequest rollbackApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rollbackApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, rollbackApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RollbackApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RollbackApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rollbackApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$rollbackApplication$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$rollbackApplication$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartApplicationResponse> startApplication(StartApplicationRequest startApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, startApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$startApplication$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$startApplication$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopApplicationResponse> stopApplication(StopApplicationRequest stopApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, stopApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$stopApplication$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$stopApplication$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$tagResource$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$tagResource$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$untagResource$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$untagResource$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$updateApplication$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$updateApplication$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationMaintenanceConfigurationResponse> updateApplicationMaintenanceConfiguration(UpdateApplicationMaintenanceConfigurationRequest updateApplicationMaintenanceConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationMaintenanceConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsV2AsyncClient.resolveMetricPublishers(clientConfiguration, updateApplicationMaintenanceConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplicationMaintenanceConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationMaintenanceConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "UnableToDetectSchemaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToDetectSchemaException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "ResourceProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "InvalidApplicationConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "CodeValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CodeValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CodeValidationException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationMaintenanceConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApplicationMaintenanceConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApplicationMaintenanceConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsV2AsyncClient.lambda$updateApplicationMaintenanceConfiguration$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsV2AsyncClient.lambda$updateApplicationMaintenanceConfiguration$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final KinesisAnalyticsV2ServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisAnalyticsV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "kinesisanalytics";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisAnalyticsV2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisAnalyticsV2ServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisAnalyticsV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateApplicationMaintenanceConfiguration$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplicationMaintenanceConfiguration$130(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApplicationMaintenanceConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApplication$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplication$126(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$122(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$118(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopApplication$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopApplication$114(List metricPublishers, MetricCollector apiCallMetricCollector, StopApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startApplication$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startApplication$110(List metricPublishers, MetricCollector apiCallMetricCollector, StartApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rollbackApplication$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackApplication$106(List metricPublishers, MetricCollector apiCallMetricCollector, RollbackApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApplications$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplications$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListApplicationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApplicationVersions$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationVersions$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListApplicationVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApplicationSnapshots$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationSnapshots$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListApplicationSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApplicationOperations$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationOperations$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListApplicationOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$discoverInputSchema$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInputSchema$82(List metricPublishers, MetricCollector apiCallMetricCollector, DiscoverInputSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeApplicationVersion$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationVersion$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeApplicationVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeApplicationSnapshot$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationSnapshot$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeApplicationSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeApplicationOperation$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationOperation$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeApplicationOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeApplication$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplication$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationVpcConfiguration$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationVpcConfiguration$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationVpcConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationSnapshot$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationSnapshot$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationReferenceDataSource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationReferenceDataSource$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationReferenceDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationOutput$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationOutput$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationInputProcessingConfiguration$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationInputProcessingConfiguration$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationInputProcessingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationCloudWatchLoggingOption$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationCloudWatchLoggingOption$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationCloudWatchLoggingOptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplication$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplication$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApplicationSnapshot$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationSnapshot$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApplicationSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApplicationPresignedUrl$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationPresignedUrl$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApplicationPresignedUrlResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApplication$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationVpcConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationVpcConfiguration$22(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationVpcConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationReferenceDataSource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationReferenceDataSource$18(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationReferenceDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationOutput$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationOutput$14(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationInputProcessingConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInputProcessingConfiguration$10(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationInputProcessingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationInput$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInput$6(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationCloudWatchLoggingOption$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationCloudWatchLoggingOption$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationCloudWatchLoggingOptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

