/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationInputResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<AddApplicationInputResponse.Builder, AddApplicationInputResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(AddApplicationInputResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApplicationVersionId").getter(getter(AddApplicationInputResponse::applicationVersionId))
            .setter(setter(Builder::applicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build())
            .build();

    private static final SdkField<List<InputDescription>> INPUT_DESCRIPTIONS_FIELD = SdkField
            .<List<InputDescription>> builder(MarshallingType.LIST)
            .memberName("InputDescriptions")
            .getter(getter(AddApplicationInputResponse::inputDescriptions))
            .setter(setter(Builder::inputDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_VERSION_ID_FIELD, INPUT_DESCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationARN;

    private final Long applicationVersionId;

    private final List<InputDescription> inputDescriptions;

    private AddApplicationInputResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.inputDescriptions = builder.inputDescriptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Provides the current application version.
     * </p>
     * 
     * @return Provides the current application version.
     */
    public final Long applicationVersionId() {
        return applicationVersionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDescriptions() {
        return inputDescriptions != null && !(inputDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the application input configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDescriptions} method.
     * </p>
     * 
     * @return Describes the application input configuration.
     */
    public final List<InputDescription> inputDescriptions() {
        return inputDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDescriptions() ? inputDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputResponse)) {
            return false;
        }
        AddApplicationInputResponse other = (AddApplicationInputResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationVersionId(), other.applicationVersionId())
                && hasInputDescriptions() == other.hasInputDescriptions()
                && Objects.equals(inputDescriptions(), other.inputDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationInputResponse").add("ApplicationARN", applicationARN())
                .add("ApplicationVersionId", applicationVersionId())
                .add("InputDescriptions", hasInputDescriptions() ? inputDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationVersionId":
            return Optional.ofNullable(clazz.cast(applicationVersionId()));
        case "InputDescriptions":
            return Optional.ofNullable(clazz.cast(inputDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("InputDescriptions", INPUT_DESCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputResponse, T> g) {
        return obj -> g.apply((AddApplicationInputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationInputResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationARN
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Provides the current application version.
         * </p>
         * 
         * @param applicationVersionId
         *        Provides the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionId(Long applicationVersionId);

        /**
         * <p>
         * Describes the application input configuration.
         * </p>
         * 
         * @param inputDescriptions
         *        Describes the application input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(Collection<InputDescription> inputDescriptions);

        /**
         * <p>
         * Describes the application input configuration.
         * </p>
         * 
         * @param inputDescriptions
         *        Describes the application input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescriptions(InputDescription... inputDescriptions);

        /**
         * <p>
         * Describes the application input configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDescriptions(List<InputDescription>)}.
         * 
         * @param inputDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDescriptions(java.util.Collection<InputDescription>)
         */
        Builder inputDescriptions(Consumer<InputDescription.Builder>... inputDescriptions);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private Long applicationVersionId;

        private List<InputDescription> inputDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationVersionId(model.applicationVersionId);
            inputDescriptions(model.inputDescriptions);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final Long getApplicationVersionId() {
            return applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final List<InputDescription.Builder> getInputDescriptions() {
            List<InputDescription.Builder> result = InputDescriptionsCopier.copyToBuilder(this.inputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription... inputDescriptions) {
            inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder>... inputDescriptions) {
            inputDescriptions(Stream.of(inputDescriptions).map(c -> InputDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddApplicationInputResponse build() {
            return new AddApplicationInputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
