/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration updates to encryption at rest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationEncryptionConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationEncryptionConfigurationUpdate.Builder, ApplicationEncryptionConfigurationUpdate> {
    private static final SdkField<String> KEY_ID_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdUpdate").getter(getter(ApplicationEncryptionConfigurationUpdate::keyIdUpdate))
            .setter(setter(Builder::keyIdUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdUpdate").build()).build();

    private static final SdkField<String> KEY_TYPE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyTypeUpdate").getter(getter(ApplicationEncryptionConfigurationUpdate::keyTypeUpdateAsString))
            .setter(setter(Builder::keyTypeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyTypeUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_UPDATE_FIELD,
            KEY_TYPE_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyIdUpdate;

    private final String keyTypeUpdate;

    private ApplicationEncryptionConfigurationUpdate(BuilderImpl builder) {
        this.keyIdUpdate = builder.keyIdUpdate;
        this.keyTypeUpdate = builder.keyTypeUpdate;
    }

    /**
     * <p>
     * The key ARN, key ID, alias ARN, or alias name of the KMS key to be used for encryption at rest.
     * </p>
     * 
     * @return The key ARN, key ID, alias ARN, or alias name of the KMS key to be used for encryption at rest.
     */
    public final String keyIdUpdate() {
        return keyIdUpdate;
    }

    /**
     * <p>
     * Specifies the type of key to be used for encryption at rest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyTypeUpdate}
     * will return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeUpdateAsString}.
     * </p>
     * 
     * @return Specifies the type of key to be used for encryption at rest.
     * @see KeyType
     */
    public final KeyType keyTypeUpdate() {
        return KeyType.fromValue(keyTypeUpdate);
    }

    /**
     * <p>
     * Specifies the type of key to be used for encryption at rest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyTypeUpdate}
     * will return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeUpdateAsString}.
     * </p>
     * 
     * @return Specifies the type of key to be used for encryption at rest.
     * @see KeyType
     */
    public final String keyTypeUpdateAsString() {
        return keyTypeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyIdUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeUpdateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationEncryptionConfigurationUpdate)) {
            return false;
        }
        ApplicationEncryptionConfigurationUpdate other = (ApplicationEncryptionConfigurationUpdate) obj;
        return Objects.equals(keyIdUpdate(), other.keyIdUpdate())
                && Objects.equals(keyTypeUpdateAsString(), other.keyTypeUpdateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationEncryptionConfigurationUpdate").add("KeyIdUpdate", keyIdUpdate())
                .add("KeyTypeUpdate", keyTypeUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyIdUpdate":
            return Optional.ofNullable(clazz.cast(keyIdUpdate()));
        case "KeyTypeUpdate":
            return Optional.ofNullable(clazz.cast(keyTypeUpdateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyIdUpdate", KEY_ID_UPDATE_FIELD);
        map.put("KeyTypeUpdate", KEY_TYPE_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationEncryptionConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationEncryptionConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationEncryptionConfigurationUpdate> {
        /**
         * <p>
         * The key ARN, key ID, alias ARN, or alias name of the KMS key to be used for encryption at rest.
         * </p>
         * 
         * @param keyIdUpdate
         *        The key ARN, key ID, alias ARN, or alias name of the KMS key to be used for encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdUpdate(String keyIdUpdate);

        /**
         * <p>
         * Specifies the type of key to be used for encryption at rest.
         * </p>
         * 
         * @param keyTypeUpdate
         *        Specifies the type of key to be used for encryption at rest.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyTypeUpdate(String keyTypeUpdate);

        /**
         * <p>
         * Specifies the type of key to be used for encryption at rest.
         * </p>
         * 
         * @param keyTypeUpdate
         *        Specifies the type of key to be used for encryption at rest.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyTypeUpdate(KeyType keyTypeUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String keyIdUpdate;

        private String keyTypeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationEncryptionConfigurationUpdate model) {
            keyIdUpdate(model.keyIdUpdate);
            keyTypeUpdate(model.keyTypeUpdate);
        }

        public final String getKeyIdUpdate() {
            return keyIdUpdate;
        }

        public final void setKeyIdUpdate(String keyIdUpdate) {
            this.keyIdUpdate = keyIdUpdate;
        }

        @Override
        public final Builder keyIdUpdate(String keyIdUpdate) {
            this.keyIdUpdate = keyIdUpdate;
            return this;
        }

        public final String getKeyTypeUpdate() {
            return keyTypeUpdate;
        }

        public final void setKeyTypeUpdate(String keyTypeUpdate) {
            this.keyTypeUpdate = keyTypeUpdate;
        }

        @Override
        public final Builder keyTypeUpdate(String keyTypeUpdate) {
            this.keyTypeUpdate = keyTypeUpdate;
            return this;
        }

        @Override
        public final Builder keyTypeUpdate(KeyType keyTypeUpdate) {
            this.keyTypeUpdate(keyTypeUpdate == null ? null : keyTypeUpdate.toString());
            return this;
        }

        @Override
        public ApplicationEncryptionConfigurationUpdate build() {
            return new ApplicationEncryptionConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
