/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to whether snapshots are enabled for a Managed Service for Apache Flink application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSnapshotConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSnapshotConfigurationUpdate.Builder, ApplicationSnapshotConfigurationUpdate> {
    private static final SdkField<Boolean> SNAPSHOTS_ENABLED_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SnapshotsEnabledUpdate").getter(getter(ApplicationSnapshotConfigurationUpdate::snapshotsEnabledUpdate))
            .setter(setter(Builder::snapshotsEnabledUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotsEnabledUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SNAPSHOTS_ENABLED_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean snapshotsEnabledUpdate;

    private ApplicationSnapshotConfigurationUpdate(BuilderImpl builder) {
        this.snapshotsEnabledUpdate = builder.snapshotsEnabledUpdate;
    }

    /**
     * <p>
     * Describes updates to whether snapshots are enabled for an application.
     * </p>
     * 
     * @return Describes updates to whether snapshots are enabled for an application.
     */
    public final Boolean snapshotsEnabledUpdate() {
        return snapshotsEnabledUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotsEnabledUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSnapshotConfigurationUpdate)) {
            return false;
        }
        ApplicationSnapshotConfigurationUpdate other = (ApplicationSnapshotConfigurationUpdate) obj;
        return Objects.equals(snapshotsEnabledUpdate(), other.snapshotsEnabledUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSnapshotConfigurationUpdate").add("SnapshotsEnabledUpdate", snapshotsEnabledUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotsEnabledUpdate":
            return Optional.ofNullable(clazz.cast(snapshotsEnabledUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotsEnabledUpdate", SNAPSHOTS_ENABLED_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSnapshotConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationSnapshotConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSnapshotConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to whether snapshots are enabled for an application.
         * </p>
         * 
         * @param snapshotsEnabledUpdate
         *        Describes updates to whether snapshots are enabled for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotsEnabledUpdate(Boolean snapshotsEnabledUpdate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean snapshotsEnabledUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSnapshotConfigurationUpdate model) {
            snapshotsEnabledUpdate(model.snapshotsEnabledUpdate);
        }

        public final Boolean getSnapshotsEnabledUpdate() {
            return snapshotsEnabledUpdate;
        }

        public final void setSnapshotsEnabledUpdate(Boolean snapshotsEnabledUpdate) {
            this.snapshotsEnabledUpdate = snapshotsEnabledUpdate;
        }

        @Override
        public final Builder snapshotsEnabledUpdate(Boolean snapshotsEnabledUpdate) {
            this.snapshotsEnabledUpdate = snapshotsEnabledUpdate;
            return this;
        }

        @Override
        public ApplicationSnapshotConfigurationUpdate build() {
            return new ApplicationSnapshotConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
