/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies dependency JARs, as well as JAR files that contain user-defined functions (UDF).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomArtifactConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomArtifactConfiguration.Builder, CustomArtifactConfiguration> {
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactType").getter(getter(CustomArtifactConfiguration::artifactTypeAsString))
            .setter(setter(Builder::artifactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()).build();

    private static final SdkField<S3ContentLocation> S3_CONTENT_LOCATION_FIELD = SdkField
            .<S3ContentLocation> builder(MarshallingType.SDK_POJO).memberName("S3ContentLocation")
            .getter(getter(CustomArtifactConfiguration::s3ContentLocation)).setter(setter(Builder::s3ContentLocation))
            .constructor(S3ContentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocation").build()).build();

    private static final SdkField<MavenReference> MAVEN_REFERENCE_FIELD = SdkField
            .<MavenReference> builder(MarshallingType.SDK_POJO).memberName("MavenReference")
            .getter(getter(CustomArtifactConfiguration::mavenReference)).setter(setter(Builder::mavenReference))
            .constructor(MavenReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MavenReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPE_FIELD,
            S3_CONTENT_LOCATION_FIELD, MAVEN_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String artifactType;

    private final S3ContentLocation s3ContentLocation;

    private final MavenReference mavenReference;

    private CustomArtifactConfiguration(BuilderImpl builder) {
        this.artifactType = builder.artifactType;
        this.s3ContentLocation = builder.s3ContentLocation;
        this.mavenReference = builder.mavenReference;
    }

    /**
     * <p>
     * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactType} will
     * return {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #artifactTypeAsString}.
     * </p>
     * 
     * @return <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     *         <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * @see ArtifactType
     */
    public final ArtifactType artifactType() {
        return ArtifactType.fromValue(artifactType);
    }

    /**
     * <p>
     * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactType} will
     * return {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #artifactTypeAsString}.
     * </p>
     * 
     * @return <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     *         <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * @see ArtifactType
     */
    public final String artifactTypeAsString() {
        return artifactType;
    }

    /**
     * Returns the value of the S3ContentLocation property for this object.
     * 
     * @return The value of the S3ContentLocation property for this object.
     */
    public final S3ContentLocation s3ContentLocation() {
        return s3ContentLocation;
    }

    /**
     * <p>
     * The parameters required to fully specify a Maven reference.
     * </p>
     * 
     * @return The parameters required to fully specify a Maven reference.
     */
    public final MavenReference mavenReference() {
        return mavenReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(mavenReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomArtifactConfiguration)) {
            return false;
        }
        CustomArtifactConfiguration other = (CustomArtifactConfiguration) obj;
        return Objects.equals(artifactTypeAsString(), other.artifactTypeAsString())
                && Objects.equals(s3ContentLocation(), other.s3ContentLocation())
                && Objects.equals(mavenReference(), other.mavenReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomArtifactConfiguration").add("ArtifactType", artifactTypeAsString())
                .add("S3ContentLocation", s3ContentLocation()).add("MavenReference", mavenReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactType":
            return Optional.ofNullable(clazz.cast(artifactTypeAsString()));
        case "S3ContentLocation":
            return Optional.ofNullable(clazz.cast(s3ContentLocation()));
        case "MavenReference":
            return Optional.ofNullable(clazz.cast(mavenReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArtifactType", ARTIFACT_TYPE_FIELD);
        map.put("S3ContentLocation", S3_CONTENT_LOCATION_FIELD);
        map.put("MavenReference", MAVEN_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomArtifactConfiguration, T> g) {
        return obj -> g.apply((CustomArtifactConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomArtifactConfiguration> {
        /**
         * <p>
         * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * </p>
         * 
         * @param artifactType
         *        <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         *        <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder artifactType(String artifactType);

        /**
         * <p>
         * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * </p>
         * 
         * @param artifactType
         *        <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         *        <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder artifactType(ArtifactType artifactType);

        /**
         * Sets the value of the S3ContentLocation property for this object.
         *
         * @param s3ContentLocation
         *        The new value for the S3ContentLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocation(S3ContentLocation s3ContentLocation);

        /**
         * Sets the value of the S3ContentLocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3ContentLocation.Builder} avoiding the
         * need to create one manually via {@link S3ContentLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ContentLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #s3ContentLocation(S3ContentLocation)}.
         * 
         * @param s3ContentLocation
         *        a consumer that will call methods on {@link S3ContentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocation(S3ContentLocation)
         */
        default Builder s3ContentLocation(Consumer<S3ContentLocation.Builder> s3ContentLocation) {
            return s3ContentLocation(S3ContentLocation.builder().applyMutation(s3ContentLocation).build());
        }

        /**
         * <p>
         * The parameters required to fully specify a Maven reference.
         * </p>
         * 
         * @param mavenReference
         *        The parameters required to fully specify a Maven reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mavenReference(MavenReference mavenReference);

        /**
         * <p>
         * The parameters required to fully specify a Maven reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link MavenReference.Builder} avoiding the need
         * to create one manually via {@link MavenReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MavenReference.Builder#build()} is called immediately and its
         * result is passed to {@link #mavenReference(MavenReference)}.
         * 
         * @param mavenReference
         *        a consumer that will call methods on {@link MavenReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mavenReference(MavenReference)
         */
        default Builder mavenReference(Consumer<MavenReference.Builder> mavenReference) {
            return mavenReference(MavenReference.builder().applyMutation(mavenReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String artifactType;

        private S3ContentLocation s3ContentLocation;

        private MavenReference mavenReference;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomArtifactConfiguration model) {
            artifactType(model.artifactType);
            s3ContentLocation(model.s3ContentLocation);
            mavenReference(model.mavenReference);
        }

        public final String getArtifactType() {
            return artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        @Override
        public final Builder artifactType(ArtifactType artifactType) {
            this.artifactType(artifactType == null ? null : artifactType.toString());
            return this;
        }

        public final S3ContentLocation.Builder getS3ContentLocation() {
            return s3ContentLocation != null ? s3ContentLocation.toBuilder() : null;
        }

        public final void setS3ContentLocation(S3ContentLocation.BuilderImpl s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation != null ? s3ContentLocation.build() : null;
        }

        @Override
        public final Builder s3ContentLocation(S3ContentLocation s3ContentLocation) {
            this.s3ContentLocation = s3ContentLocation;
            return this;
        }

        public final MavenReference.Builder getMavenReference() {
            return mavenReference != null ? mavenReference.toBuilder() : null;
        }

        public final void setMavenReference(MavenReference.BuilderImpl mavenReference) {
            this.mavenReference = mavenReference != null ? mavenReference.build() : null;
        }

        @Override
        public final Builder mavenReference(MavenReference mavenReference) {
            this.mavenReference = mavenReference;
            return this;
        }

        @Override
        public CustomArtifactConfiguration build() {
            return new CustomArtifactConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
