/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a dependency JAR or a JAR of user-defined functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomArtifactConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomArtifactConfigurationDescription.Builder, CustomArtifactConfigurationDescription> {
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactType").getter(getter(CustomArtifactConfigurationDescription::artifactTypeAsString))
            .setter(setter(Builder::artifactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()).build();

    private static final SdkField<S3ContentLocation> S3_CONTENT_LOCATION_DESCRIPTION_FIELD = SdkField
            .<S3ContentLocation> builder(MarshallingType.SDK_POJO)
            .memberName("S3ContentLocationDescription")
            .getter(getter(CustomArtifactConfigurationDescription::s3ContentLocationDescription))
            .setter(setter(Builder::s3ContentLocationDescription))
            .constructor(S3ContentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationDescription")
                    .build()).build();

    private static final SdkField<MavenReference> MAVEN_REFERENCE_DESCRIPTION_FIELD = SdkField
            .<MavenReference> builder(MarshallingType.SDK_POJO).memberName("MavenReferenceDescription")
            .getter(getter(CustomArtifactConfigurationDescription::mavenReferenceDescription))
            .setter(setter(Builder::mavenReferenceDescription)).constructor(MavenReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MavenReferenceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPE_FIELD,
            S3_CONTENT_LOCATION_DESCRIPTION_FIELD, MAVEN_REFERENCE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String artifactType;

    private final S3ContentLocation s3ContentLocationDescription;

    private final MavenReference mavenReferenceDescription;

    private CustomArtifactConfigurationDescription(BuilderImpl builder) {
        this.artifactType = builder.artifactType;
        this.s3ContentLocationDescription = builder.s3ContentLocationDescription;
        this.mavenReferenceDescription = builder.mavenReferenceDescription;
    }

    /**
     * <p>
     * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactType} will
     * return {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #artifactTypeAsString}.
     * </p>
     * 
     * @return <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     *         <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * @see ArtifactType
     */
    public final ArtifactType artifactType() {
        return ArtifactType.fromValue(artifactType);
    }

    /**
     * <p>
     * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactType} will
     * return {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #artifactTypeAsString}.
     * </p>
     * 
     * @return <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
     *         <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
     * @see ArtifactType
     */
    public final String artifactTypeAsString() {
        return artifactType;
    }

    /**
     * Returns the value of the S3ContentLocationDescription property for this object.
     * 
     * @return The value of the S3ContentLocationDescription property for this object.
     */
    public final S3ContentLocation s3ContentLocationDescription() {
        return s3ContentLocationDescription;
    }

    /**
     * <p>
     * The parameters that are required to specify a Maven dependency.
     * </p>
     * 
     * @return The parameters that are required to specify a Maven dependency.
     */
    public final MavenReference mavenReferenceDescription() {
        return mavenReferenceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3ContentLocationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(mavenReferenceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomArtifactConfigurationDescription)) {
            return false;
        }
        CustomArtifactConfigurationDescription other = (CustomArtifactConfigurationDescription) obj;
        return Objects.equals(artifactTypeAsString(), other.artifactTypeAsString())
                && Objects.equals(s3ContentLocationDescription(), other.s3ContentLocationDescription())
                && Objects.equals(mavenReferenceDescription(), other.mavenReferenceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomArtifactConfigurationDescription").add("ArtifactType", artifactTypeAsString())
                .add("S3ContentLocationDescription", s3ContentLocationDescription())
                .add("MavenReferenceDescription", mavenReferenceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactType":
            return Optional.ofNullable(clazz.cast(artifactTypeAsString()));
        case "S3ContentLocationDescription":
            return Optional.ofNullable(clazz.cast(s3ContentLocationDescription()));
        case "MavenReferenceDescription":
            return Optional.ofNullable(clazz.cast(mavenReferenceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArtifactType", ARTIFACT_TYPE_FIELD);
        map.put("S3ContentLocationDescription", S3_CONTENT_LOCATION_DESCRIPTION_FIELD);
        map.put("MavenReferenceDescription", MAVEN_REFERENCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomArtifactConfigurationDescription, T> g) {
        return obj -> g.apply((CustomArtifactConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomArtifactConfigurationDescription> {
        /**
         * <p>
         * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * </p>
         * 
         * @param artifactType
         *        <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         *        <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder artifactType(String artifactType);

        /**
         * <p>
         * <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         * <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * </p>
         * 
         * @param artifactType
         *        <code>UDF</code> stands for user-defined functions. This type of artifact must be in an S3 bucket. A
         *        <code>DEPENDENCY_JAR</code> can be in either Maven or an S3 bucket.
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder artifactType(ArtifactType artifactType);

        /**
         * Sets the value of the S3ContentLocationDescription property for this object.
         *
         * @param s3ContentLocationDescription
         *        The new value for the S3ContentLocationDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ContentLocationDescription(S3ContentLocation s3ContentLocationDescription);

        /**
         * Sets the value of the S3ContentLocationDescription property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3ContentLocation.Builder} avoiding the
         * need to create one manually via {@link S3ContentLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ContentLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #s3ContentLocationDescription(S3ContentLocation)}.
         * 
         * @param s3ContentLocationDescription
         *        a consumer that will call methods on {@link S3ContentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ContentLocationDescription(S3ContentLocation)
         */
        default Builder s3ContentLocationDescription(Consumer<S3ContentLocation.Builder> s3ContentLocationDescription) {
            return s3ContentLocationDescription(S3ContentLocation.builder().applyMutation(s3ContentLocationDescription).build());
        }

        /**
         * <p>
         * The parameters that are required to specify a Maven dependency.
         * </p>
         * 
         * @param mavenReferenceDescription
         *        The parameters that are required to specify a Maven dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mavenReferenceDescription(MavenReference mavenReferenceDescription);

        /**
         * <p>
         * The parameters that are required to specify a Maven dependency.
         * </p>
         * This is a convenience method that creates an instance of the {@link MavenReference.Builder} avoiding the need
         * to create one manually via {@link MavenReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MavenReference.Builder#build()} is called immediately and its
         * result is passed to {@link #mavenReferenceDescription(MavenReference)}.
         * 
         * @param mavenReferenceDescription
         *        a consumer that will call methods on {@link MavenReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mavenReferenceDescription(MavenReference)
         */
        default Builder mavenReferenceDescription(Consumer<MavenReference.Builder> mavenReferenceDescription) {
            return mavenReferenceDescription(MavenReference.builder().applyMutation(mavenReferenceDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String artifactType;

        private S3ContentLocation s3ContentLocationDescription;

        private MavenReference mavenReferenceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomArtifactConfigurationDescription model) {
            artifactType(model.artifactType);
            s3ContentLocationDescription(model.s3ContentLocationDescription);
            mavenReferenceDescription(model.mavenReferenceDescription);
        }

        public final String getArtifactType() {
            return artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        @Override
        public final Builder artifactType(ArtifactType artifactType) {
            this.artifactType(artifactType == null ? null : artifactType.toString());
            return this;
        }

        public final S3ContentLocation.Builder getS3ContentLocationDescription() {
            return s3ContentLocationDescription != null ? s3ContentLocationDescription.toBuilder() : null;
        }

        public final void setS3ContentLocationDescription(S3ContentLocation.BuilderImpl s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription != null ? s3ContentLocationDescription.build()
                    : null;
        }

        @Override
        public final Builder s3ContentLocationDescription(S3ContentLocation s3ContentLocationDescription) {
            this.s3ContentLocationDescription = s3ContentLocationDescription;
            return this;
        }

        public final MavenReference.Builder getMavenReferenceDescription() {
            return mavenReferenceDescription != null ? mavenReferenceDescription.toBuilder() : null;
        }

        public final void setMavenReferenceDescription(MavenReference.BuilderImpl mavenReferenceDescription) {
            this.mavenReferenceDescription = mavenReferenceDescription != null ? mavenReferenceDescription.build() : null;
        }

        @Override
        public final Builder mavenReferenceDescription(MavenReference mavenReferenceDescription) {
            this.mavenReferenceDescription = mavenReferenceDescription;
            return this;
        }

        @Override
        public CustomArtifactConfigurationDescription build() {
            return new CustomArtifactConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
