/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationOutputRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<DeleteApplicationOutputRequest.Builder, DeleteApplicationOutputRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DeleteApplicationOutputRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(DeleteApplicationOutputRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<String> OUTPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputId").getter(getter(DeleteApplicationOutputRequest::outputId)).setter(setter(Builder::outputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, OUTPUT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String outputId;

    private DeleteApplicationOutputRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.outputId = builder.outputId;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The application version. You can use the <a>DescribeApplication</a> operation to get the current application
     * version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is
     * returned.
     * </p>
     * 
     * @return The application version. You can use the <a>DescribeApplication</a> operation to get the current
     *         application version. If the version specified is not the current version, the
     *         <code>ConcurrentModificationException</code> is returned.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the configuration to delete. Each output configuration that is added to the application (either when
     * the application is created or later) using the <a>AddApplicationOutput</a> operation has a unique ID. You need to
     * provide the ID to uniquely identify the output configuration that you want to delete from the application
     * configuration. You can use the <a>DescribeApplication</a> operation to get the specific <code>OutputId</code>.
     * </p>
     * 
     * @return The ID of the configuration to delete. Each output configuration that is added to the application (either
     *         when the application is created or later) using the <a>AddApplicationOutput</a> operation has a unique
     *         ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from
     *         the application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
     *         <code>OutputId</code>.
     */
    public final String outputId() {
        return outputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationOutputRequest)) {
            return false;
        }
        DeleteApplicationOutputRequest other = (DeleteApplicationOutputRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(outputId(), other.outputId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationOutputRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId()).add("OutputId", outputId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "OutputId":
            return Optional.ofNullable(clazz.cast(outputId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("CurrentApplicationVersionId", CURRENT_APPLICATION_VERSION_ID_FIELD);
        map.put("OutputId", OUTPUT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationOutputRequest, T> g) {
        return obj -> g.apply((DeleteApplicationOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationOutputRequest> {
        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The application version. You can use the <a>DescribeApplication</a> operation to get the current application
         * version. If the version specified is not the current version, the
         * <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The application version. You can use the <a>DescribeApplication</a> operation to get the current
         *        application version. If the version specified is not the current version, the
         *        <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the configuration to delete. Each output configuration that is added to the application (either
         * when the application is created or later) using the <a>AddApplicationOutput</a> operation has a unique ID.
         * You need to provide the ID to uniquely identify the output configuration that you want to delete from the
         * application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
         * <code>OutputId</code>.
         * </p>
         * 
         * @param outputId
         *        The ID of the configuration to delete. Each output configuration that is added to the application
         *        (either when the application is created or later) using the <a>AddApplicationOutput</a> operation has
         *        a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to
         *        delete from the application configuration. You can use the <a>DescribeApplication</a> operation to get
         *        the specific <code>OutputId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String outputId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationOutputRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            outputId(model.outputId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getOutputId() {
            return outputId;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationOutputRequest build() {
            return new DeleteApplicationOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
