/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationVpcConfigurationRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<DeleteApplicationVpcConfigurationRequest.Builder, DeleteApplicationVpcConfigurationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DeleteApplicationVpcConfigurationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(DeleteApplicationVpcConfigurationRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<String> VPC_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConfigurationId").getter(getter(DeleteApplicationVpcConfigurationRequest::vpcConfigurationId))
            .setter(setter(Builder::vpcConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationId").build())
            .build();

    private static final SdkField<String> CONDITIONAL_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionalToken").getter(getter(DeleteApplicationVpcConfigurationRequest::conditionalToken))
            .setter(setter(Builder::conditionalToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, VPC_CONFIGURATION_ID_FIELD, CONDITIONAL_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String vpcConfigurationId;

    private final String conditionalToken;

    private DeleteApplicationVpcConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.vpcConfigurationId = builder.vpcConfigurationId;
        this.conditionalToken = builder.conditionalToken;
    }

    /**
     * <p>
     * The name of an existing application.
     * </p>
     * 
     * @return The name of an existing application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     *         <code>ConditionalToken</code>. You can retrieve the application version ID using
     *         <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
     *         parameter instead of <code>CurrentApplicationVersionId</code>.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the VPC configuration to delete.
     * </p>
     * 
     * @return The ID of the VPC configuration to delete.
     */
    public final String vpcConfigurationId() {
        return vpcConfigurationId;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return A value you use to implement strong concurrency for application updates. You must provide the
     *         <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
     *         current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support,
     *         use the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     */
    public final String conditionalToken() {
        return conditionalToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationVpcConfigurationRequest)) {
            return false;
        }
        DeleteApplicationVpcConfigurationRequest other = (DeleteApplicationVpcConfigurationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(vpcConfigurationId(), other.vpcConfigurationId())
                && Objects.equals(conditionalToken(), other.conditionalToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationVpcConfigurationRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("VpcConfigurationId", vpcConfigurationId()).add("ConditionalToken", conditionalToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "VpcConfigurationId":
            return Optional.ofNullable(clazz.cast(vpcConfigurationId()));
        case "ConditionalToken":
            return Optional.ofNullable(clazz.cast(conditionalToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("CurrentApplicationVersionId", CURRENT_APPLICATION_VERSION_ID_FIELD);
        map.put("VpcConfigurationId", VPC_CONFIGURATION_ID_FIELD);
        map.put("ConditionalToken", CONDITIONAL_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationVpcConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteApplicationVpcConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationVpcConfigurationRequest> {
        /**
         * <p>
         * The name of an existing application.
         * </p>
         * 
         * @param applicationName
         *        The name of an existing application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
         * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>.
         * For better concurrency support, use the <code>ConditionalToken</code> parameter instead of
         * <code>CurrentApplicationVersionId</code>.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or
         *        the <code>ConditionalToken</code>. You can retrieve the application version ID using
         *        <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
         *        parameter instead of <code>CurrentApplicationVersionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the VPC configuration to delete.
         * </p>
         * 
         * @param vpcConfigurationId
         *        The ID of the VPC configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationId(String vpcConfigurationId);

        /**
         * <p>
         * A value you use to implement strong concurrency for application updates. You must provide the
         * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
         * current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use
         * the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
         * </p>
         * 
         * @param conditionalToken
         *        A value you use to implement strong concurrency for application updates. You must provide the
         *        <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the
         *        application's current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better
         *        concurrency support, use the <code>ConditionalToken</code> parameter instead of
         *        <code>CurrentApplicationVersionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalToken(String conditionalToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String vpcConfigurationId;

        private String conditionalToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationVpcConfigurationRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            vpcConfigurationId(model.vpcConfigurationId);
            conditionalToken(model.conditionalToken);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getVpcConfigurationId() {
            return vpcConfigurationId;
        }

        public final void setVpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
        }

        @Override
        public final Builder vpcConfigurationId(String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
            return this;
        }

        public final String getConditionalToken() {
            return conditionalToken;
        }

        public final void setConditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
        }

        @Override
        public final Builder conditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationVpcConfigurationRequest build() {
            return new DeleteApplicationVpcConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
