/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the operation that corresponds to the operation ID on a Managed Service for Apache Flink
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationOperationResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<DescribeApplicationOperationResponse.Builder, DescribeApplicationOperationResponse> {
    private static final SdkField<ApplicationOperationInfoDetails> APPLICATION_OPERATION_INFO_DETAILS_FIELD = SdkField
            .<ApplicationOperationInfoDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationOperationInfoDetails")
            .getter(getter(DescribeApplicationOperationResponse::applicationOperationInfoDetails))
            .setter(setter(Builder::applicationOperationInfoDetails))
            .constructor(ApplicationOperationInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationOperationInfoDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_OPERATION_INFO_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApplicationOperationInfoDetails applicationOperationInfoDetails;

    private DescribeApplicationOperationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationOperationInfoDetails = builder.applicationOperationInfoDetails;
    }

    /**
     * Returns the value of the ApplicationOperationInfoDetails property for this object.
     * 
     * @return The value of the ApplicationOperationInfoDetails property for this object.
     */
    public final ApplicationOperationInfoDetails applicationOperationInfoDetails() {
        return applicationOperationInfoDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationOperationInfoDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationOperationResponse)) {
            return false;
        }
        DescribeApplicationOperationResponse other = (DescribeApplicationOperationResponse) obj;
        return Objects.equals(applicationOperationInfoDetails(), other.applicationOperationInfoDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationOperationResponse")
                .add("ApplicationOperationInfoDetails", applicationOperationInfoDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationOperationInfoDetails":
            return Optional.ofNullable(clazz.cast(applicationOperationInfoDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationOperationInfoDetails", APPLICATION_OPERATION_INFO_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationOperationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationOperationResponse> {
        /**
         * Sets the value of the ApplicationOperationInfoDetails property for this object.
         *
         * @param applicationOperationInfoDetails
         *        The new value for the ApplicationOperationInfoDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationOperationInfoDetails(ApplicationOperationInfoDetails applicationOperationInfoDetails);

        /**
         * Sets the value of the ApplicationOperationInfoDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationOperationInfoDetails.Builder}
         * avoiding the need to create one manually via {@link ApplicationOperationInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationOperationInfoDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationOperationInfoDetails(ApplicationOperationInfoDetails)}.
         * 
         * @param applicationOperationInfoDetails
         *        a consumer that will call methods on {@link ApplicationOperationInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationOperationInfoDetails(ApplicationOperationInfoDetails)
         */
        default Builder applicationOperationInfoDetails(
                Consumer<ApplicationOperationInfoDetails.Builder> applicationOperationInfoDetails) {
            return applicationOperationInfoDetails(ApplicationOperationInfoDetails.builder()
                    .applyMutation(applicationOperationInfoDetails).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private ApplicationOperationInfoDetails applicationOperationInfoDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationOperationResponse model) {
            super(model);
            applicationOperationInfoDetails(model.applicationOperationInfoDetails);
        }

        public final ApplicationOperationInfoDetails.Builder getApplicationOperationInfoDetails() {
            return applicationOperationInfoDetails != null ? applicationOperationInfoDetails.toBuilder() : null;
        }

        public final void setApplicationOperationInfoDetails(
                ApplicationOperationInfoDetails.BuilderImpl applicationOperationInfoDetails) {
            this.applicationOperationInfoDetails = applicationOperationInfoDetails != null ? applicationOperationInfoDetails
                    .build() : null;
        }

        @Override
        public final Builder applicationOperationInfoDetails(ApplicationOperationInfoDetails applicationOperationInfoDetails) {
            this.applicationOperationInfoDetails = applicationOperationInfoDetails;
            return this;
        }

        @Override
        public DescribeApplicationOperationResponse build() {
            return new DescribeApplicationOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
