/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationSnapshotResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<DescribeApplicationSnapshotResponse.Builder, DescribeApplicationSnapshotResponse> {
    private static final SdkField<SnapshotDetails> SNAPSHOT_DETAILS_FIELD = SdkField
            .<SnapshotDetails> builder(MarshallingType.SDK_POJO).memberName("SnapshotDetails")
            .getter(getter(DescribeApplicationSnapshotResponse::snapshotDetails)).setter(setter(Builder::snapshotDetails))
            .constructor(SnapshotDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SnapshotDetails snapshotDetails;

    private DescribeApplicationSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotDetails = builder.snapshotDetails;
    }

    /**
     * <p>
     * An object containing information about the application snapshot.
     * </p>
     * 
     * @return An object containing information about the application snapshot.
     */
    public final SnapshotDetails snapshotDetails() {
        return snapshotDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationSnapshotResponse)) {
            return false;
        }
        DescribeApplicationSnapshotResponse other = (DescribeApplicationSnapshotResponse) obj;
        return Objects.equals(snapshotDetails(), other.snapshotDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationSnapshotResponse").add("SnapshotDetails", snapshotDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotDetails":
            return Optional.ofNullable(clazz.cast(snapshotDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotDetails", SNAPSHOT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationSnapshotResponse, T> g) {
        return obj -> g.apply((DescribeApplicationSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationSnapshotResponse> {
        /**
         * <p>
         * An object containing information about the application snapshot.
         * </p>
         * 
         * @param snapshotDetails
         *        An object containing information about the application snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(SnapshotDetails snapshotDetails);

        /**
         * <p>
         * An object containing information about the application snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotDetails.Builder} avoiding the
         * need to create one manually via {@link SnapshotDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotDetails(SnapshotDetails)}.
         * 
         * @param snapshotDetails
         *        a consumer that will call methods on {@link SnapshotDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotDetails(SnapshotDetails)
         */
        default Builder snapshotDetails(Consumer<SnapshotDetails.Builder> snapshotDetails) {
            return snapshotDetails(SnapshotDetails.builder().applyMutation(snapshotDetails).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private SnapshotDetails snapshotDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationSnapshotResponse model) {
            super(model);
            snapshotDetails(model.snapshotDetails);
        }

        public final SnapshotDetails.Builder getSnapshotDetails() {
            return snapshotDetails != null ? snapshotDetails.toBuilder() : null;
        }

        public final void setSnapshotDetails(SnapshotDetails.BuilderImpl snapshotDetails) {
            this.snapshotDetails = snapshotDetails != null ? snapshotDetails.build() : null;
        }

        @Override
        public final Builder snapshotDetails(SnapshotDetails snapshotDetails) {
            this.snapshotDetails = snapshotDetails;
            return this;
        }

        @Override
        public DescribeApplicationSnapshotResponse build() {
            return new DescribeApplicationSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
