/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the execution properties for an Apache Flink runtime.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentPropertyDescriptions implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentPropertyDescriptions.Builder, EnvironmentPropertyDescriptions> {
    private static final SdkField<List<PropertyGroup>> PROPERTY_GROUP_DESCRIPTIONS_FIELD = SdkField
            .<List<PropertyGroup>> builder(MarshallingType.LIST)
            .memberName("PropertyGroupDescriptions")
            .getter(getter(EnvironmentPropertyDescriptions::propertyGroupDescriptions))
            .setter(setter(Builder::propertyGroupDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroupDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROPERTY_GROUP_DESCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PropertyGroup> propertyGroupDescriptions;

    private EnvironmentPropertyDescriptions(BuilderImpl builder) {
        this.propertyGroupDescriptions = builder.propertyGroupDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroupDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropertyGroupDescriptions() {
        return propertyGroupDescriptions != null && !(propertyGroupDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the execution property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroupDescriptions} method.
     * </p>
     * 
     * @return Describes the execution property groups.
     */
    public final List<PropertyGroup> propertyGroupDescriptions() {
        return propertyGroupDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroupDescriptions() ? propertyGroupDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPropertyDescriptions)) {
            return false;
        }
        EnvironmentPropertyDescriptions other = (EnvironmentPropertyDescriptions) obj;
        return hasPropertyGroupDescriptions() == other.hasPropertyGroupDescriptions()
                && Objects.equals(propertyGroupDescriptions(), other.propertyGroupDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentPropertyDescriptions")
                .add("PropertyGroupDescriptions", hasPropertyGroupDescriptions() ? propertyGroupDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyGroupDescriptions":
            return Optional.ofNullable(clazz.cast(propertyGroupDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PropertyGroupDescriptions", PROPERTY_GROUP_DESCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentPropertyDescriptions, T> g) {
        return obj -> g.apply((EnvironmentPropertyDescriptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentPropertyDescriptions> {
        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroupDescriptions
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroupDescriptions(Collection<PropertyGroup> propertyGroupDescriptions);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * 
         * @param propertyGroupDescriptions
         *        Describes the execution property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroupDescriptions(PropertyGroup... propertyGroupDescriptions);

        /**
         * <p>
         * Describes the execution property groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyGroupDescriptions(List<PropertyGroup>)}.
         * 
         * @param propertyGroupDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyGroupDescriptions(java.util.Collection<PropertyGroup>)
         */
        Builder propertyGroupDescriptions(Consumer<PropertyGroup.Builder>... propertyGroupDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private List<PropertyGroup> propertyGroupDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPropertyDescriptions model) {
            propertyGroupDescriptions(model.propertyGroupDescriptions);
        }

        public final List<PropertyGroup.Builder> getPropertyGroupDescriptions() {
            List<PropertyGroup.Builder> result = PropertyGroupsCopier.copyToBuilder(this.propertyGroupDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroupDescriptions(Collection<PropertyGroup.BuilderImpl> propertyGroupDescriptions) {
            this.propertyGroupDescriptions = PropertyGroupsCopier.copyFromBuilder(propertyGroupDescriptions);
        }

        @Override
        public final Builder propertyGroupDescriptions(Collection<PropertyGroup> propertyGroupDescriptions) {
            this.propertyGroupDescriptions = PropertyGroupsCopier.copy(propertyGroupDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroupDescriptions(PropertyGroup... propertyGroupDescriptions) {
            propertyGroupDescriptions(Arrays.asList(propertyGroupDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroupDescriptions(Consumer<PropertyGroup.Builder>... propertyGroupDescriptions) {
            propertyGroupDescriptions(Stream.of(propertyGroupDescriptions)
                    .map(c -> PropertyGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnvironmentPropertyDescriptions build() {
            return new EnvironmentPropertyDescriptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
