/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to the configuration parameters for a Managed Service for Apache Flink application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlinkApplicationConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<FlinkApplicationConfigurationUpdate.Builder, FlinkApplicationConfigurationUpdate> {
    private static final SdkField<CheckpointConfigurationUpdate> CHECKPOINT_CONFIGURATION_UPDATE_FIELD = SdkField
            .<CheckpointConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("CheckpointConfigurationUpdate")
            .getter(getter(FlinkApplicationConfigurationUpdate::checkpointConfigurationUpdate))
            .setter(setter(Builder::checkpointConfigurationUpdate))
            .constructor(CheckpointConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfigurationUpdate")
                    .build()).build();

    private static final SdkField<MonitoringConfigurationUpdate> MONITORING_CONFIGURATION_UPDATE_FIELD = SdkField
            .<MonitoringConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringConfigurationUpdate")
            .getter(getter(FlinkApplicationConfigurationUpdate::monitoringConfigurationUpdate))
            .setter(setter(Builder::monitoringConfigurationUpdate))
            .constructor(MonitoringConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationUpdate")
                    .build()).build();

    private static final SdkField<ParallelismConfigurationUpdate> PARALLELISM_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ParallelismConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ParallelismConfigurationUpdate")
            .getter(getter(FlinkApplicationConfigurationUpdate::parallelismConfigurationUpdate))
            .setter(setter(Builder::parallelismConfigurationUpdate))
            .constructor(ParallelismConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfigurationUpdate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CHECKPOINT_CONFIGURATION_UPDATE_FIELD, MONITORING_CONFIGURATION_UPDATE_FIELD,
                    PARALLELISM_CONFIGURATION_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CheckpointConfigurationUpdate checkpointConfigurationUpdate;

    private final MonitoringConfigurationUpdate monitoringConfigurationUpdate;

    private final ParallelismConfigurationUpdate parallelismConfigurationUpdate;

    private FlinkApplicationConfigurationUpdate(BuilderImpl builder) {
        this.checkpointConfigurationUpdate = builder.checkpointConfigurationUpdate;
        this.monitoringConfigurationUpdate = builder.monitoringConfigurationUpdate;
        this.parallelismConfigurationUpdate = builder.parallelismConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to an application's checkpointing configuration. Checkpointing is the process of persisting
     * application state for fault tolerance.
     * </p>
     * 
     * @return Describes updates to an application's checkpointing configuration. Checkpointing is the process of
     *         persisting application state for fault tolerance.
     */
    public final CheckpointConfigurationUpdate checkpointConfigurationUpdate() {
        return checkpointConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to the configuration parameters for Amazon CloudWatch logging for an application.
     * </p>
     * 
     * @return Describes updates to the configuration parameters for Amazon CloudWatch logging for an application.
     */
    public final MonitoringConfigurationUpdate monitoringConfigurationUpdate() {
        return monitoringConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to the parameters for how an application executes multiple tasks simultaneously.
     * </p>
     * 
     * @return Describes updates to the parameters for how an application executes multiple tasks simultaneously.
     */
    public final ParallelismConfigurationUpdate parallelismConfigurationUpdate() {
        return parallelismConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfigurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkApplicationConfigurationUpdate)) {
            return false;
        }
        FlinkApplicationConfigurationUpdate other = (FlinkApplicationConfigurationUpdate) obj;
        return Objects.equals(checkpointConfigurationUpdate(), other.checkpointConfigurationUpdate())
                && Objects.equals(monitoringConfigurationUpdate(), other.monitoringConfigurationUpdate())
                && Objects.equals(parallelismConfigurationUpdate(), other.parallelismConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlinkApplicationConfigurationUpdate")
                .add("CheckpointConfigurationUpdate", checkpointConfigurationUpdate())
                .add("MonitoringConfigurationUpdate", monitoringConfigurationUpdate())
                .add("ParallelismConfigurationUpdate", parallelismConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckpointConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(checkpointConfigurationUpdate()));
        case "MonitoringConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(monitoringConfigurationUpdate()));
        case "ParallelismConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(parallelismConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CheckpointConfigurationUpdate", CHECKPOINT_CONFIGURATION_UPDATE_FIELD);
        map.put("MonitoringConfigurationUpdate", MONITORING_CONFIGURATION_UPDATE_FIELD);
        map.put("ParallelismConfigurationUpdate", PARALLELISM_CONFIGURATION_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlinkApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((FlinkApplicationConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlinkApplicationConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance.
         * </p>
         * 
         * @param checkpointConfigurationUpdate
         *        Describes updates to an application's checkpointing configuration. Checkpointing is the process of
         *        persisting application state for fault tolerance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfigurationUpdate(CheckpointConfigurationUpdate checkpointConfigurationUpdate);

        /**
         * <p>
         * Describes updates to an application's checkpointing configuration. Checkpointing is the process of persisting
         * application state for fault tolerance.
         * </p>
         * This is a convenience method that creates an instance of the {@link CheckpointConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link CheckpointConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CheckpointConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #checkpointConfigurationUpdate(CheckpointConfigurationUpdate)}.
         * 
         * @param checkpointConfigurationUpdate
         *        a consumer that will call methods on {@link CheckpointConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfigurationUpdate(CheckpointConfigurationUpdate)
         */
        default Builder checkpointConfigurationUpdate(
                Consumer<CheckpointConfigurationUpdate.Builder> checkpointConfigurationUpdate) {
            return checkpointConfigurationUpdate(CheckpointConfigurationUpdate.builder()
                    .applyMutation(checkpointConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to the configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * 
         * @param monitoringConfigurationUpdate
         *        Describes updates to the configuration parameters for Amazon CloudWatch logging for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfigurationUpdate(MonitoringConfigurationUpdate monitoringConfigurationUpdate);

        /**
         * <p>
         * Describes updates to the configuration parameters for Amazon CloudWatch logging for an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link MonitoringConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoringConfigurationUpdate(MonitoringConfigurationUpdate)}.
         * 
         * @param monitoringConfigurationUpdate
         *        a consumer that will call methods on {@link MonitoringConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfigurationUpdate(MonitoringConfigurationUpdate)
         */
        default Builder monitoringConfigurationUpdate(
                Consumer<MonitoringConfigurationUpdate.Builder> monitoringConfigurationUpdate) {
            return monitoringConfigurationUpdate(MonitoringConfigurationUpdate.builder()
                    .applyMutation(monitoringConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to the parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * 
         * @param parallelismConfigurationUpdate
         *        Describes updates to the parameters for how an application executes multiple tasks simultaneously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfigurationUpdate(ParallelismConfigurationUpdate parallelismConfigurationUpdate);

        /**
         * <p>
         * Describes updates to the parameters for how an application executes multiple tasks simultaneously.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelismConfigurationUpdate.Builder}
         * avoiding the need to create one manually via {@link ParallelismConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelismConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #parallelismConfigurationUpdate(ParallelismConfigurationUpdate)}.
         * 
         * @param parallelismConfigurationUpdate
         *        a consumer that will call methods on {@link ParallelismConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfigurationUpdate(ParallelismConfigurationUpdate)
         */
        default Builder parallelismConfigurationUpdate(
                Consumer<ParallelismConfigurationUpdate.Builder> parallelismConfigurationUpdate) {
            return parallelismConfigurationUpdate(ParallelismConfigurationUpdate.builder()
                    .applyMutation(parallelismConfigurationUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CheckpointConfigurationUpdate checkpointConfigurationUpdate;

        private MonitoringConfigurationUpdate monitoringConfigurationUpdate;

        private ParallelismConfigurationUpdate parallelismConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkApplicationConfigurationUpdate model) {
            checkpointConfigurationUpdate(model.checkpointConfigurationUpdate);
            monitoringConfigurationUpdate(model.monitoringConfigurationUpdate);
            parallelismConfigurationUpdate(model.parallelismConfigurationUpdate);
        }

        public final CheckpointConfigurationUpdate.Builder getCheckpointConfigurationUpdate() {
            return checkpointConfigurationUpdate != null ? checkpointConfigurationUpdate.toBuilder() : null;
        }

        public final void setCheckpointConfigurationUpdate(CheckpointConfigurationUpdate.BuilderImpl checkpointConfigurationUpdate) {
            this.checkpointConfigurationUpdate = checkpointConfigurationUpdate != null ? checkpointConfigurationUpdate.build()
                    : null;
        }

        @Override
        public final Builder checkpointConfigurationUpdate(CheckpointConfigurationUpdate checkpointConfigurationUpdate) {
            this.checkpointConfigurationUpdate = checkpointConfigurationUpdate;
            return this;
        }

        public final MonitoringConfigurationUpdate.Builder getMonitoringConfigurationUpdate() {
            return monitoringConfigurationUpdate != null ? monitoringConfigurationUpdate.toBuilder() : null;
        }

        public final void setMonitoringConfigurationUpdate(MonitoringConfigurationUpdate.BuilderImpl monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate != null ? monitoringConfigurationUpdate.build()
                    : null;
        }

        @Override
        public final Builder monitoringConfigurationUpdate(MonitoringConfigurationUpdate monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate;
            return this;
        }

        public final ParallelismConfigurationUpdate.Builder getParallelismConfigurationUpdate() {
            return parallelismConfigurationUpdate != null ? parallelismConfigurationUpdate.toBuilder() : null;
        }

        public final void setParallelismConfigurationUpdate(
                ParallelismConfigurationUpdate.BuilderImpl parallelismConfigurationUpdate) {
            this.parallelismConfigurationUpdate = parallelismConfigurationUpdate != null ? parallelismConfigurationUpdate.build()
                    : null;
        }

        @Override
        public final Builder parallelismConfigurationUpdate(ParallelismConfigurationUpdate parallelismConfigurationUpdate) {
            this.parallelismConfigurationUpdate = parallelismConfigurationUpdate;
            return this;
        }

        @Override
        public FlinkApplicationConfigurationUpdate build() {
            return new FlinkApplicationConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
