/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that returns a list of operations for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationOperationsResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<ListApplicationOperationsResponse.Builder, ListApplicationOperationsResponse> {
    private static final SdkField<List<ApplicationOperationInfo>> APPLICATION_OPERATION_INFO_LIST_FIELD = SdkField
            .<List<ApplicationOperationInfo>> builder(MarshallingType.LIST)
            .memberName("ApplicationOperationInfoList")
            .getter(getter(ListApplicationOperationsResponse::applicationOperationInfoList))
            .setter(setter(Builder::applicationOperationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationOperationInfoList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationOperationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationOperationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationOperationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_OPERATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ApplicationOperationInfo> applicationOperationInfoList;

    private final String nextToken;

    private ListApplicationOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationOperationInfoList = builder.applicationOperationInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationOperationInfoList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationOperationInfoList() {
        return applicationOperationInfoList != null && !(applicationOperationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ApplicationOperationInfoList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationOperationInfoList} method.
     * </p>
     * 
     * @return The value of the ApplicationOperationInfoList property for this object.
     */
    public final List<ApplicationOperationInfo> applicationOperationInfoList() {
        return applicationOperationInfoList;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationOperationInfoList() ? applicationOperationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationOperationsResponse)) {
            return false;
        }
        ListApplicationOperationsResponse other = (ListApplicationOperationsResponse) obj;
        return hasApplicationOperationInfoList() == other.hasApplicationOperationInfoList()
                && Objects.equals(applicationOperationInfoList(), other.applicationOperationInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationOperationsResponse")
                .add("ApplicationOperationInfoList", hasApplicationOperationInfoList() ? applicationOperationInfoList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationOperationInfoList":
            return Optional.ofNullable(clazz.cast(applicationOperationInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationOperationInfoList", APPLICATION_OPERATION_INFO_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationOperationsResponse, T> g) {
        return obj -> g.apply((ListApplicationOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationOperationsResponse> {
        /**
         * Sets the value of the ApplicationOperationInfoList property for this object.
         *
         * @param applicationOperationInfoList
         *        The new value for the ApplicationOperationInfoList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationOperationInfoList(Collection<ApplicationOperationInfo> applicationOperationInfoList);

        /**
         * Sets the value of the ApplicationOperationInfoList property for this object.
         *
         * @param applicationOperationInfoList
         *        The new value for the ApplicationOperationInfoList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationOperationInfoList(ApplicationOperationInfo... applicationOperationInfoList);

        /**
         * Sets the value of the ApplicationOperationInfoList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #applicationOperationInfoList(List<ApplicationOperationInfo>)}.
         * 
         * @param applicationOperationInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationOperationInfoList(java.util.Collection<ApplicationOperationInfo>)
         */
        Builder applicationOperationInfoList(Consumer<ApplicationOperationInfo.Builder>... applicationOperationInfoList);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private List<ApplicationOperationInfo> applicationOperationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationOperationsResponse model) {
            super(model);
            applicationOperationInfoList(model.applicationOperationInfoList);
            nextToken(model.nextToken);
        }

        public final List<ApplicationOperationInfo.Builder> getApplicationOperationInfoList() {
            List<ApplicationOperationInfo.Builder> result = ApplicationOperationInfoListCopier
                    .copyToBuilder(this.applicationOperationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationOperationInfoList(
                Collection<ApplicationOperationInfo.BuilderImpl> applicationOperationInfoList) {
            this.applicationOperationInfoList = ApplicationOperationInfoListCopier.copyFromBuilder(applicationOperationInfoList);
        }

        @Override
        public final Builder applicationOperationInfoList(Collection<ApplicationOperationInfo> applicationOperationInfoList) {
            this.applicationOperationInfoList = ApplicationOperationInfoListCopier.copy(applicationOperationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationOperationInfoList(ApplicationOperationInfo... applicationOperationInfoList) {
            applicationOperationInfoList(Arrays.asList(applicationOperationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationOperationInfoList(
                Consumer<ApplicationOperationInfo.Builder>... applicationOperationInfoList) {
            applicationOperationInfoList(Stream.of(applicationOperationInfoList)
                    .map(c -> ApplicationOperationInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationOperationsResponse build() {
            return new ListApplicationOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
