/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, describes the mapping of each data element in the streaming
 * source to the corresponding column in the in-application stream.
 * </p>
 * <p>
 * Also used to describe the format of the reference data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordColumn implements SdkPojo, Serializable, ToCopyableBuilder<RecordColumn.Builder, RecordColumn> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RecordColumn::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MAPPING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mapping")
            .getter(getter(RecordColumn::mapping)).setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build()).build();

    private static final SdkField<String> SQL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqlType").getter(getter(RecordColumn::sqlType)).setter(setter(Builder::sqlType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAPPING_FIELD,
            SQL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String mapping;

    private final String sqlType;

    private RecordColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.mapping = builder.mapping;
        this.sqlType = builder.sqlType;
    }

    /**
     * <p>
     * The name of the column that is created in the in-application input stream or reference table.
     * </p>
     * 
     * @return The name of the column that is created in the in-application input stream or reference table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A reference to the data element in the streaming input or the reference data source.
     * </p>
     * 
     * @return A reference to the data element in the streaming input or the reference data source.
     */
    public final String mapping() {
        return mapping;
    }

    /**
     * <p>
     * The type of column created in the in-application input stream or reference table.
     * </p>
     * 
     * @return The type of column created in the in-application input stream or reference table.
     */
    public final String sqlType() {
        return sqlType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mapping());
        hashCode = 31 * hashCode + Objects.hashCode(sqlType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordColumn)) {
            return false;
        }
        RecordColumn other = (RecordColumn) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(mapping(), other.mapping())
                && Objects.equals(sqlType(), other.sqlType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordColumn").add("Name", name()).add("Mapping", mapping()).add("SqlType", sqlType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        case "SqlType":
            return Optional.ofNullable(clazz.cast(sqlType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Mapping", MAPPING_FIELD);
        map.put("SqlType", SQL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordColumn, T> g) {
        return obj -> g.apply((RecordColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordColumn> {
        /**
         * <p>
         * The name of the column that is created in the in-application input stream or reference table.
         * </p>
         * 
         * @param name
         *        The name of the column that is created in the in-application input stream or reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A reference to the data element in the streaming input or the reference data source.
         * </p>
         * 
         * @param mapping
         *        A reference to the data element in the streaming input or the reference data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(String mapping);

        /**
         * <p>
         * The type of column created in the in-application input stream or reference table.
         * </p>
         * 
         * @param sqlType
         *        The type of column created in the in-application input stream or reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlType(String sqlType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String mapping;

        private String sqlType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordColumn model) {
            name(model.name);
            mapping(model.mapping);
            sqlType(model.sqlType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMapping() {
            return mapping;
        }

        public final void setMapping(String mapping) {
            this.mapping = mapping;
        }

        @Override
        public final Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        public final String getSqlType() {
            return sqlType;
        }

        public final void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        @Override
        public final Builder sqlType(String sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        @Override
        public RecordColumn build() {
            return new RecordColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
