/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, describes the reference data source configured for an
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceDataSourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceDataSourceDescription.Builder, ReferenceDataSourceDescription> {
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceId").getter(getter(ReferenceDataSourceDescription::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ReferenceDataSourceDescription::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<S3ReferenceDataSourceDescription> S3_REFERENCE_DATA_SOURCE_DESCRIPTION_FIELD = SdkField
            .<S3ReferenceDataSourceDescription> builder(MarshallingType.SDK_POJO)
            .memberName("S3ReferenceDataSourceDescription")
            .getter(getter(ReferenceDataSourceDescription::s3ReferenceDataSourceDescription))
            .setter(setter(Builder::s3ReferenceDataSourceDescription))
            .constructor(S3ReferenceDataSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReferenceDataSourceDescription")
                    .build()).build();

    private static final SdkField<SourceSchema> REFERENCE_SCHEMA_FIELD = SdkField
            .<SourceSchema> builder(MarshallingType.SDK_POJO).memberName("ReferenceSchema")
            .getter(getter(ReferenceDataSourceDescription::referenceSchema)).setter(setter(Builder::referenceSchema))
            .constructor(SourceSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD,
            TABLE_NAME_FIELD, S3_REFERENCE_DATA_SOURCE_DESCRIPTION_FIELD, REFERENCE_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String referenceId;

    private final String tableName;

    private final S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;

    private final SourceSchema referenceSchema;

    private ReferenceDataSourceDescription(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableName = builder.tableName;
        this.s3ReferenceDataSourceDescription = builder.s3ReferenceDataSourceDescription;
        this.referenceSchema = builder.referenceSchema;
    }

    /**
     * <p>
     * The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add the
     * reference data source to your application using the <a>CreateApplication</a> or <a>UpdateApplication</a>
     * operation.
     * </p>
     * 
     * @return The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add the
     *         reference data source to your application using the <a>CreateApplication</a> or <a>UpdateApplication</a>
     *         operation.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * The in-application table name created by the specific reference data source configuration.
     * </p>
     * 
     * @return The in-application table name created by the specific reference data source configuration.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Provides the Amazon S3 bucket name, the object key name that contains the reference data.
     * </p>
     * 
     * @return Provides the Amazon S3 bucket name, the object key name that contains the reference data.
     */
    public final S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription() {
        return s3ReferenceDataSourceDescription;
    }

    /**
     * <p>
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
     * created in the in-application stream.
     * </p>
     * 
     * @return Describes the format of the data in the streaming source, and how each data element maps to corresponding
     *         columns created in the in-application stream.
     */
    public final SourceSchema referenceSchema() {
        return referenceSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(s3ReferenceDataSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(referenceSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceDescription)) {
            return false;
        }
        ReferenceDataSourceDescription other = (ReferenceDataSourceDescription) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(s3ReferenceDataSourceDescription(), other.s3ReferenceDataSourceDescription())
                && Objects.equals(referenceSchema(), other.referenceSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceDataSourceDescription").add("ReferenceId", referenceId()).add("TableName", tableName())
                .add("S3ReferenceDataSourceDescription", s3ReferenceDataSourceDescription())
                .add("ReferenceSchema", referenceSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "S3ReferenceDataSourceDescription":
            return Optional.ofNullable(clazz.cast(s3ReferenceDataSourceDescription()));
        case "ReferenceSchema":
            return Optional.ofNullable(clazz.cast(referenceSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("S3ReferenceDataSourceDescription", S3_REFERENCE_DATA_SOURCE_DESCRIPTION_FIELD);
        map.put("ReferenceSchema", REFERENCE_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDataSourceDescription, T> g) {
        return obj -> g.apply((ReferenceDataSourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceDataSourceDescription> {
        /**
         * <p>
         * The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add the
         * reference data source to your application using the <a>CreateApplication</a> or <a>UpdateApplication</a>
         * operation.
         * </p>
         * 
         * @param referenceId
         *        The ID of the reference data source. This is the ID that Kinesis Data Analytics assigns when you add
         *        the reference data source to your application using the <a>CreateApplication</a> or
         *        <a>UpdateApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * The in-application table name created by the specific reference data source configuration.
         * </p>
         * 
         * @param tableName
         *        The in-application table name created by the specific reference data source configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Provides the Amazon S3 bucket name, the object key name that contains the reference data.
         * </p>
         * 
         * @param s3ReferenceDataSourceDescription
         *        Provides the Amazon S3 bucket name, the object key name that contains the reference data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription);

        /**
         * <p>
         * Provides the Amazon S3 bucket name, the object key name that contains the reference data.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ReferenceDataSourceDescription.Builder}
         * avoiding the need to create one manually via {@link S3ReferenceDataSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ReferenceDataSourceDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription)}.
         * 
         * @param s3ReferenceDataSourceDescription
         *        a consumer that will call methods on {@link S3ReferenceDataSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription)
         */
        default Builder s3ReferenceDataSourceDescription(
                Consumer<S3ReferenceDataSourceDescription.Builder> s3ReferenceDataSourceDescription) {
            return s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription.builder()
                    .applyMutation(s3ReferenceDataSourceDescription).build());
        }

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns created in the in-application stream.
         * </p>
         * 
         * @param referenceSchema
         *        Describes the format of the data in the streaming source, and how each data element maps to
         *        corresponding columns created in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchema(SourceSchema referenceSchema);

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns created in the in-application stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceSchema.Builder} avoiding the need
         * to create one manually via {@link SourceSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #referenceSchema(SourceSchema)}.
         * 
         * @param referenceSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceSchema(SourceSchema)
         */
        default Builder referenceSchema(Consumer<SourceSchema.Builder> referenceSchema) {
            return referenceSchema(SourceSchema.builder().applyMutation(referenceSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String referenceId;

        private String tableName;

        private S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;

        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceDescription model) {
            referenceId(model.referenceId);
            tableName(model.tableName);
            s3ReferenceDataSourceDescription(model.s3ReferenceDataSourceDescription);
            referenceSchema(model.referenceSchema);
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final S3ReferenceDataSourceDescription.Builder getS3ReferenceDataSourceDescription() {
            return s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription.toBuilder() : null;
        }

        public final void setS3ReferenceDataSourceDescription(
                S3ReferenceDataSourceDescription.BuilderImpl s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription
                    .build() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription;
            return this;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return referenceSchema != null ? referenceSchema.toBuilder() : null;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        @Override
        public ReferenceDataSourceDescription build() {
            return new ReferenceDataSourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
