/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackApplicationResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<RollbackApplicationResponse.Builder, RollbackApplicationResponse> {
    private static final SdkField<ApplicationDetail> APPLICATION_DETAIL_FIELD = SdkField
            .<ApplicationDetail> builder(MarshallingType.SDK_POJO).memberName("ApplicationDetail")
            .getter(getter(RollbackApplicationResponse::applicationDetail)).setter(setter(Builder::applicationDetail))
            .constructor(ApplicationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDetail").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(RollbackApplicationResponse::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_DETAIL_FIELD,
            OPERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApplicationDetail applicationDetail;

    private final String operationId;

    private RollbackApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationDetail = builder.applicationDetail;
        this.operationId = builder.operationId;
    }

    /**
     * Returns the value of the ApplicationDetail property for this object.
     * 
     * @return The value of the ApplicationDetail property for this object.
     */
    public final ApplicationDetail applicationDetail() {
        return applicationDetail;
    }

    /**
     * <p>
     * The operation ID that can be used to track the request.
     * </p>
     * 
     * @return The operation ID that can be used to track the request.
     */
    public final String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackApplicationResponse)) {
            return false;
        }
        RollbackApplicationResponse other = (RollbackApplicationResponse) obj;
        return Objects.equals(applicationDetail(), other.applicationDetail())
                && Objects.equals(operationId(), other.operationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackApplicationResponse").add("ApplicationDetail", applicationDetail())
                .add("OperationId", operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationDetail":
            return Optional.ofNullable(clazz.cast(applicationDetail()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationDetail", APPLICATION_DETAIL_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollbackApplicationResponse, T> g) {
        return obj -> g.apply((RollbackApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, RollbackApplicationResponse> {
        /**
         * Sets the value of the ApplicationDetail property for this object.
         *
         * @param applicationDetail
         *        The new value for the ApplicationDetail property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDetail(ApplicationDetail applicationDetail);

        /**
         * Sets the value of the ApplicationDetail property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationDetail.Builder} avoiding the
         * need to create one manually via {@link ApplicationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationDetail(ApplicationDetail)}.
         * 
         * @param applicationDetail
         *        a consumer that will call methods on {@link ApplicationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationDetail(ApplicationDetail)
         */
        default Builder applicationDetail(Consumer<ApplicationDetail.Builder> applicationDetail) {
            return applicationDetail(ApplicationDetail.builder().applyMutation(applicationDetail).build());
        }

        /**
         * <p>
         * The operation ID that can be used to track the request.
         * </p>
         * 
         * @param operationId
         *        The operation ID that can be used to track the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private ApplicationDetail applicationDetail;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackApplicationResponse model) {
            super(model);
            applicationDetail(model.applicationDetail);
            operationId(model.operationId);
        }

        public final ApplicationDetail.Builder getApplicationDetail() {
            return applicationDetail != null ? applicationDetail.toBuilder() : null;
        }

        public final void setApplicationDetail(ApplicationDetail.BuilderImpl applicationDetail) {
            this.applicationDetail = applicationDetail != null ? applicationDetail.build() : null;
        }

        @Override
        public final Builder applicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public RollbackApplicationResponse build() {
            return new RollbackApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
