/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information required to update the S3 base location that holds the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ContentBaseLocationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ContentBaseLocationUpdate.Builder, S3ContentBaseLocationUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARNUpdate").getter(getter(S3ContentBaseLocationUpdate::bucketARNUpdate))
            .setter(setter(Builder::bucketARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()).build();

    private static final SdkField<String> BASE_PATH_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BasePathUpdate").getter(getter(S3ContentBaseLocationUpdate::basePathUpdate))
            .setter(setter(Builder::basePathUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasePathUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD,
            BASE_PATH_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketARNUpdate;

    private final String basePathUpdate;

    private S3ContentBaseLocationUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.basePathUpdate = builder.basePathUpdate;
    }

    /**
     * <p>
     * The updated Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return The updated Amazon Resource Name (ARN) of the S3 bucket.
     */
    public final String bucketARNUpdate() {
        return bucketARNUpdate;
    }

    /**
     * <p>
     * The updated S3 bucket path.
     * </p>
     * 
     * @return The updated S3 bucket path.
     */
    public final String basePathUpdate() {
        return basePathUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(basePathUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentBaseLocationUpdate)) {
            return false;
        }
        S3ContentBaseLocationUpdate other = (S3ContentBaseLocationUpdate) obj;
        return Objects.equals(bucketARNUpdate(), other.bucketARNUpdate())
                && Objects.equals(basePathUpdate(), other.basePathUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ContentBaseLocationUpdate").add("BucketARNUpdate", bucketARNUpdate())
                .add("BasePathUpdate", basePathUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARNUpdate":
            return Optional.ofNullable(clazz.cast(bucketARNUpdate()));
        case "BasePathUpdate":
            return Optional.ofNullable(clazz.cast(basePathUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketARNUpdate", BUCKET_ARN_UPDATE_FIELD);
        map.put("BasePathUpdate", BASE_PATH_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ContentBaseLocationUpdate, T> g) {
        return obj -> g.apply((S3ContentBaseLocationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ContentBaseLocationUpdate> {
        /**
         * <p>
         * The updated Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARNUpdate
         *        The updated Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARNUpdate(String bucketARNUpdate);

        /**
         * <p>
         * The updated S3 bucket path.
         * </p>
         * 
         * @param basePathUpdate
         *        The updated S3 bucket path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePathUpdate(String basePathUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARNUpdate;

        private String basePathUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentBaseLocationUpdate model) {
            bucketARNUpdate(model.bucketARNUpdate);
            basePathUpdate(model.basePathUpdate);
        }

        public final String getBucketARNUpdate() {
            return bucketARNUpdate;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final String getBasePathUpdate() {
            return basePathUpdate;
        }

        public final void setBasePathUpdate(String basePathUpdate) {
            this.basePathUpdate = basePathUpdate;
        }

        @Override
        public final Builder basePathUpdate(String basePathUpdate) {
            this.basePathUpdate = basePathUpdate;
            return this;
        }

        @Override
        public S3ContentBaseLocationUpdate build() {
            return new S3ContentBaseLocationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
