/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<CreateStreamRequest.Builder, CreateStreamRequest> {
    private final String deviceName;

    private final String streamName;

    private final String mediaType;

    private final String kmsKeyId;

    private final Integer dataRetentionInHours;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deviceName = builder.deviceName;
        this.streamName = builder.streamName;
        this.mediaType = builder.mediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    /**
     * <p>
     * The name of the device that is writing to the stream.
     * </p>
     * <note>
     * <p>
     * In the current implementation, Kinesis Video Streams does not use this name.
     * </p>
     * </note>
     * 
     * @return The name of the device that is writing to the stream. </p> <note>
     *         <p>
     *         In the current implementation, Kinesis Video Streams does not use this name.
     *         </p>
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * A name for the stream that you are creating.
     * </p>
     * <p>
     * The stream name is an identifier for the stream, and must be unique for each account and region.
     * </p>
     * 
     * @return A name for the stream that you are creating.</p>
     *         <p>
     *         The stream name is an identifier for the stream, and must be unique for each account and region.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The media type of the stream. Consumers of the stream can use this information when processing the stream. For
     * more information about media types, see <a
     * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify
     * the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
     * for guidelines.
     * </p>
     * <p>
     * To play video on the console, the media must be H.264 encoded, and you need to specify this video type in this
     * parameter as <code>video/h264</code>.
     * </p>
     * <p>
     * This parameter is optional; the default value is <code>null</code> (or empty in JSON).
     * </p>
     * 
     * @return The media type of the stream. Consumers of the stream can use this information when processing the
     *         stream. For more information about media types, see <a
     *         href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
     *         specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
     *         Requirements</a> for guidelines.</p>
     *         <p>
     *         To play video on the console, the media must be H.264 encoded, and you need to specify this video type in
     *         this parameter as <code>video/h264</code>.
     *         </p>
     *         <p>
     *         This parameter is optional; the default value is <code>null</code> (or empty in JSON).
     */
    public String mediaType() {
        return mediaType;
    }

    /**
     * <p>
     * The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt
     * stream data.
     * </p>
     * <p>
     * If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.
     * </p>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     * >DescribeKey</a>.
     * </p>
     * 
     * @return The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to
     *         encrypt stream data.</p>
     *         <p>
     *         If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is
     *         used.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     *         >DescribeKey</a>.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a
     * data store that is associated with the stream.
     * </p>
     * <p>
     * The default value is 0, indicating that the stream does not persist data.
     * </p>
     * 
     * @return The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the
     *         data in a data store that is associated with the stream.</p>
     *         <p>
     *         The default value is 0, indicating that the stream does not persist data.
     */
    public Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(mediaType(), other.mediaType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dataRetentionInHours(), other.dataRetentionInHours());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamRequest").add("DeviceName", deviceName()).add("StreamName", streamName())
                .add("MediaType", mediaType()).add("KmsKeyId", kmsKeyId()).add("DataRetentionInHours", dataRetentionInHours())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        case "MediaType":
            return Optional.of(clazz.cast(mediaType()));
        case "KmsKeyId":
            return Optional.of(clazz.cast(kmsKeyId()));
        case "DataRetentionInHours":
            return Optional.of(clazz.cast(dataRetentionInHours()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoRequest.Builder, CopyableBuilder<Builder, CreateStreamRequest> {
        /**
         * <p>
         * The name of the device that is writing to the stream.
         * </p>
         * <note>
         * <p>
         * In the current implementation, Kinesis Video Streams does not use this name.
         * </p>
         * </note>
         * 
         * @param deviceName
         *        The name of the device that is writing to the stream. </p> <note>
         *        <p>
         *        In the current implementation, Kinesis Video Streams does not use this name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * A name for the stream that you are creating.
         * </p>
         * <p>
         * The stream name is an identifier for the stream, and must be unique for each account and region.
         * </p>
         * 
         * @param streamName
         *        A name for the stream that you are creating.</p>
         *        <p>
         *        The stream name is an identifier for the stream, and must be unique for each account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The media type of the stream. Consumers of the stream can use this information when processing the stream.
         * For more information about media types, see <a
         * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         * specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
         * Requirements</a> for guidelines.
         * </p>
         * <p>
         * To play video on the console, the media must be H.264 encoded, and you need to specify this video type in
         * this parameter as <code>video/h264</code>.
         * </p>
         * <p>
         * This parameter is optional; the default value is <code>null</code> (or empty in JSON).
         * </p>
         * 
         * @param mediaType
         *        The media type of the stream. Consumers of the stream can use this information when processing the
         *        stream. For more information about media types, see <a
         *        href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         *        specify the <code>MediaType</code>, see <a
         *        href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
         *        <p>
         *        To play video on the console, the media must be H.264 encoded, and you need to specify this video type
         *        in this parameter as <code>video/h264</code>.
         *        </p>
         *        <p>
         *        This parameter is optional; the default value is <code>null</code> (or empty in JSON).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt
         * stream data.
         * </p>
         * <p>
         * If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         * >DescribeKey</a>.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to
         *        encrypt stream data.</p>
         *        <p>
         *        If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is
         *        used.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         *        >DescribeKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in
         * a data store that is associated with the stream.
         * </p>
         * <p>
         * The default value is 0, indicating that the stream does not persist data.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the
         *        data in a data store that is associated with the stream.</p>
         *        <p>
         *        The default value is 0, indicating that the stream does not persist data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String deviceName;

        private String streamName;

        private String mediaType;

        private String kmsKeyId;

        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            deviceName(model.deviceName);
            streamName(model.streamName);
            mediaType(model.mediaType);
            kmsKeyId(model.kmsKeyId);
            dataRetentionInHours(model.dataRetentionInHours);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getMediaType() {
            return mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }
    }
}
