/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<ListTagsForStreamRequest.Builder, ListTagsForStreamRequest> {
    private final String nextToken;

    private final String streamARN;

    private final String streamName;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response
     * includes a token that you can use in the next request to fetch the next batch of tags.
     * </p>
     * 
     * @return If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the
     *         response includes a token that you can use in the next request to fetch the next batch of tags.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to list tags for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to list tags for.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream that you want to list tags for.
     * </p>
     * 
     * @return The name of the stream that you want to list tags for.
     */
    public String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(streamName(), other.streamName());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForStreamRequest").add("NextToken", nextToken()).add("StreamARN", streamARN())
                .add("StreamName", streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "StreamARN":
            return Optional.of(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoRequest.Builder, CopyableBuilder<Builder, ListTagsForStreamRequest> {
        /**
         * <p>
         * If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the
         * response includes a token that you can use in the next request to fetch the next batch of tags.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated,
         *        the response includes a token that you can use in the next request to fetch the next batch of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to list tags for.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to list tags for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream that you want to list tags for.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that you want to list tags for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String streamARN;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            super(model);
            nextToken(model.nextToken);
            streamARN(model.streamARN);
            streamName(model.streamName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }
    }
}
