/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<DescribeStreamResponse.Builder, DescribeStreamResponse> {
    private final StreamInfo streamInfo;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamInfo = builder.streamInfo;
    }

    /**
     * <p>
     * An object that describes the stream.
     * </p>
     * 
     * @return An object that describes the stream.
     */
    public StreamInfo streamInfo() {
        return streamInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse) obj;
        return Objects.equals(streamInfo(), other.streamInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStreamResponse").add("StreamInfo", streamInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamInfo":
            return Optional.ofNullable(clazz.cast(streamInfo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoResponse.Builder, CopyableBuilder<Builder, DescribeStreamResponse> {
        /**
         * <p>
         * An object that describes the stream.
         * </p>
         * 
         * @param streamInfo
         *        An object that describes the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamInfo(StreamInfo streamInfo);

        /**
         * <p>
         * An object that describes the stream.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamInfo.Builder} avoiding the need to create
         * one manually via {@link StreamInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #streamInfo(StreamInfo)}.
         * 
         * @param streamInfo
         *        a consumer that will call methods on {@link StreamInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamInfo(StreamInfo)
         */
        default Builder streamInfo(Consumer<StreamInfo.Builder> streamInfo) {
            return streamInfo(StreamInfo.builder().applyMutation(streamInfo).build());
        }
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private StreamInfo streamInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            super(model);
            streamInfo(model.streamInfo);
        }

        public final StreamInfo.Builder getStreamInfo() {
            return streamInfo != null ? streamInfo.toBuilder() : null;
        }

        @Override
        public final Builder streamInfo(StreamInfo streamInfo) {
            this.streamInfo = streamInfo;
            return this;
        }

        public final void setStreamInfo(StreamInfo.BuilderImpl streamInfo) {
            this.streamInfo = streamInfo != null ? streamInfo.build() : null;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }
    }
}
