/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForStreamResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<ListTagsForStreamResponse.Builder, ListTagsForStreamResponse> {
    private final String nextToken;

    private final Map<String, String> tags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response includes
     * a token that you can use in the next request to fetch the next set of tags.
     * </p>
     * 
     * @return If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response
     *         includes a token that you can use in the next request to fetch the next set of tags.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A map of tag keys and values associated with the specified stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of tag keys and values associated with the specified stream.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForStreamResponse").add("NextToken", nextToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoResponse.Builder, CopyableBuilder<Builder, ListTagsForStreamResponse> {
        /**
         * <p>
         * If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response
         * includes a token that you can use in the next request to fetch the next set of tags.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the
         *        response includes a token that you can use in the next request to fetch the next set of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A map of tag keys and values associated with the specified stream.
         * </p>
         * 
         * @param tags
         *        A map of tag keys and values associated with the specified stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            super(model);
            nextToken(model.nextToken);
            tags(model.tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ResourceTagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ResourceTagsCopier.copy(tags);
        }

        @Override
        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }
    }
}
