/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, CreateStreamRequest> {
    private final String deviceName;
    private final String streamName;
    private final String mediaType;
    private final String kmsKeyId;
    private final Integer dataRetentionInHours;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deviceName = builder.deviceName;
        this.streamName = builder.streamName;
        this.mediaType = builder.mediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String streamName() {
        return this.streamName;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Integer dataRetentionInHours() {
        return this.dataRetentionInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionInHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest)((Object)obj);
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.mediaType(), other.mediaType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dataRetentionInHours(), other.dataRetentionInHours());
    }

    public String toString() {
        return ToString.builder((String)"CreateStreamRequest").add("DeviceName", (Object)this.deviceName()).add("StreamName", (Object)this.streamName()).add("MediaType", (Object)this.mediaType()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DataRetentionInHours", (Object)this.dataRetentionInHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "MediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DataRetentionInHours": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionInHours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String deviceName;
        private String streamName;
        private String mediaType;
        private String kmsKeyId;
        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            this.deviceName(model.deviceName);
            this.streamName(model.streamName);
            this.mediaType(model.mediaType);
            this.kmsKeyId(model.kmsKeyId);
            this.dataRetentionInHours(model.dataRetentionInHours);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getDataRetentionInHours() {
            return this.dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    CopyableBuilder<Builder, CreateStreamRequest> {
        public Builder deviceName(String var1);

        public Builder streamName(String var1);

        public Builder mediaType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder dataRetentionInHours(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

