/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForStreamRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, ListTagsForStreamRequest> {
    private final String nextToken;
    private final String streamARN;
    private final String streamName;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String streamName() {
        return this.streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"ListTagsForStreamRequest").add("NextToken", (Object)this.nextToken()).add("StreamARN", (Object)this.streamARN()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private String streamARN;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.streamARN(model.streamARN);
            this.streamName(model.streamName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    CopyableBuilder<Builder, ListTagsForStreamRequest> {
        public Builder nextToken(String var1);

        public Builder streamARN(String var1);

        public Builder streamName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

