/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<CreateStreamResponse.Builder, CreateStreamResponse> {
    private final String streamARN;

    private CreateStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream.
     */
    public String streamARN() {
        return streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamResponse)) {
            return false;
        }
        CreateStreamResponse other = (CreateStreamResponse) obj;
        return Objects.equals(streamARN(), other.streamARN());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamResponse").add("StreamARN", streamARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.of(clazz.cast(streamARN()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoResponse.Builder, CopyableBuilder<Builder, CreateStreamResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamResponse model) {
            streamARN(model.streamARN);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public CreateStreamResponse build() {
            return new CreateStreamResponse(this);
        }
    }
}
