/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDataEndpointResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<GetDataEndpointResponse.Builder, GetDataEndpointResponse> {
    private final String dataEndpoint;

    private GetDataEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.dataEndpoint = builder.dataEndpoint;
    }

    /**
     * <p>
     * The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
     * application.
     * </p>
     * 
     * @return The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
     *         application.
     */
    public String dataEndpoint() {
        return dataEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataEndpointResponse)) {
            return false;
        }
        GetDataEndpointResponse other = (GetDataEndpointResponse) obj;
        return Objects.equals(dataEndpoint(), other.dataEndpoint());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDataEndpointResponse").add("DataEndpoint", dataEndpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataEndpoint":
            return Optional.of(clazz.cast(dataEndpoint()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoResponse.Builder, CopyableBuilder<Builder, GetDataEndpointResponse> {
        /**
         * <p>
         * The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
         * application.
         * </p>
         * 
         * @param dataEndpoint
         *        The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndpoint(String dataEndpoint);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private String dataEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataEndpointResponse model) {
            dataEndpoint(model.dataEndpoint);
        }

        public final String getDataEndpoint() {
            return dataEndpoint;
        }

        @Override
        public final Builder dataEndpoint(String dataEndpoint) {
            this.dataEndpoint = dataEndpoint;
            return this;
        }

        public final void setDataEndpoint(String dataEndpoint) {
            this.dataEndpoint = dataEndpoint;
        }

        @Override
        public GetDataEndpointResponse build() {
            return new GetDataEndpointResponse(this);
        }
    }
}
