/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private final Integer maxResults;

    private final String nextToken;

    private final StreamNameCondition streamNameCondition;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.streamNameCondition = builder.streamNameCondition;
    }

    /**
     * <p>
     * The maximum number of streams to return in the response. The default is 10,000.
     * </p>
     * 
     * @return The maximum number of streams to return in the response. The default is 10,000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call
     * returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your
     * next request.
     * </p>
     * 
     * @return If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the
     *         call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this
     *         token in your next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a
     * stream name as a condition.
     * </p>
     * 
     * @return Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the
     *         prefix of a stream name as a condition.
     */
    public StreamNameCondition streamNameCondition() {
        return streamNameCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(streamNameCondition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(streamNameCondition(), other.streamNameCondition());
    }

    @Override
    public String toString() {
        return ToString.builder("ListStreamsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("StreamNameCondition", streamNameCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "StreamNameCondition":
            return Optional.of(clazz.cast(streamNameCondition()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoRequest.Builder, CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * The maximum number of streams to return in the response. The default is 10,000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of streams to return in the response. The default is 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call
         * returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in
         * your next request.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated,
         *        the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide
         *        this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix
         * of a stream name as a condition.
         * </p>
         * 
         * @param streamNameCondition
         *        Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the
         *        prefix of a stream name as a condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNameCondition(StreamNameCondition streamNameCondition);

        /**
         * <p>
         * Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix
         * of a stream name as a condition.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamNameCondition.Builder} avoiding the need
         * to create one manually via {@link StreamNameCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamNameCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #streamNameCondition(StreamNameCondition)}.
         * 
         * @param streamNameCondition
         *        a consumer that will call methods on {@link StreamNameCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamNameCondition(StreamNameCondition)
         */
        default Builder streamNameCondition(Consumer<StreamNameCondition.Builder> streamNameCondition) {
            return streamNameCondition(StreamNameCondition.builder().apply(streamNameCondition).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private StreamNameCondition streamNameCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            streamNameCondition(model.streamNameCondition);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final StreamNameCondition.Builder getStreamNameCondition() {
            return streamNameCondition != null ? streamNameCondition.toBuilder() : null;
        }

        @Override
        public final Builder streamNameCondition(StreamNameCondition streamNameCondition) {
            this.streamNameCondition = streamNameCondition;
            return this;
        }

        public final void setStreamNameCondition(StreamNameCondition.BuilderImpl streamNameCondition) {
            this.streamNameCondition = streamNameCondition != null ? streamNameCondition.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }
}
