/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisvideo.transform.StreamNameConditionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the condition that streams must satisfy to be returned when you list streams (see the
 * <code>ListStreams</code> API). A condition has a comparison operation and a value. Currently, you can specify only
 * the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamNameCondition implements StructuredPojo, ToCopyableBuilder<StreamNameCondition.Builder, StreamNameCondition> {
    private final String comparisonOperator;

    private final String comparisonValue;

    private StreamNameCondition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.comparisonValue = builder.comparisonValue;
    }

    /**
     * <p>
     * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams
     * whose names start with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
     *         streams whose names start with a given prefix.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams
     * whose names start with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
     *         streams whose names start with a given prefix.
     * @see ComparisonOperator
     */
    public String comparisonOperatorString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * A value to compare.
     * </p>
     * 
     * @return A value to compare.
     */
    public String comparisonValue() {
        return comparisonValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamNameCondition)) {
            return false;
        }
        StreamNameCondition other = (StreamNameCondition) obj;
        return Objects.equals(comparisonOperatorString(), other.comparisonOperatorString())
                && Objects.equals(comparisonValue(), other.comparisonValue());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamNameCondition").add("ComparisonOperator", comparisonOperatorString())
                .add("ComparisonValue", comparisonValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonOperator":
            return Optional.of(clazz.cast(comparisonOperatorString()));
        case "ComparisonValue":
            return Optional.of(clazz.cast(comparisonValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamNameConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamNameCondition> {
        /**
         * <p>
         * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
         * streams whose names start with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which
         *        finds streams whose names start with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
         * streams whose names start with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which
         *        finds streams whose names start with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * A value to compare.
         * </p>
         * 
         * @param comparisonValue
         *        A value to compare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonValue(String comparisonValue);
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOperator;

        private String comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamNameCondition model) {
            comparisonOperator(model.comparisonOperator);
            comparisonValue(model.comparisonValue);
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getComparisonValue() {
            return comparisonValue;
        }

        @Override
        public final Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        public final void setComparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
        }

        @Override
        public StreamNameCondition build() {
            return new StreamNameCondition(this);
        }
    }
}
