/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UntagStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UntagStreamRequest.Builder, UntagStreamRequest> {
    private final String streamARN;

    private final String streamName;

    private final List<String> tagKeyList;

    private UntagStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.tagKeyList = builder.tagKeyList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream that you want to remove tags from.
     * </p>
     * 
     * @return The name of the stream that you want to remove tags from.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * A list of the keys of the tags that you want to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the keys of the tags that you want to remove.
     */
    public List<String> tagKeyList() {
        return tagKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeyList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagStreamRequest)) {
            return false;
        }
        UntagStreamRequest other = (UntagStreamRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(tagKeyList(), other.tagKeyList());
    }

    @Override
    public String toString() {
        return ToString.builder("UntagStreamRequest").add("StreamARN", streamARN()).add("StreamName", streamName())
                .add("TagKeyList", tagKeyList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.of(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        case "TagKeyList":
            return Optional.of(clazz.cast(tagKeyList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisVideoRequest.Builder, CopyableBuilder<Builder, UntagStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to remove tags from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream that you want to remove tags from.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that you want to remove tags from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * A list of the keys of the tags that you want to remove.
         * </p>
         * 
         * @param tagKeyList
         *        A list of the keys of the tags that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(Collection<String> tagKeyList);

        /**
         * <p>
         * A list of the keys of the tags that you want to remove.
         * </p>
         * 
         * @param tagKeyList
         *        A list of the keys of the tags that you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyList(String... tagKeyList);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String streamName;

        private List<String> tagKeyList;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagStreamRequest model) {
            streamARN(model.streamARN);
            streamName(model.streamName);
            tagKeyList(model.tagKeyList);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getTagKeyList() {
            return tagKeyList;
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String... tagKeyList) {
            tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UntagStreamRequest build() {
            return new UntagStreamRequest(this);
        }
    }
}
