/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamRequest;

@SdkInternalApi
public class UntagStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<List> TAGKEYLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeyList").build();
    private static final UntagStreamRequestModelMarshaller INSTANCE = new UntagStreamRequestModelMarshaller();

    public static UntagStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UntagStreamRequest untagStreamRequest, ProtocolMarshaller protocolMarshaller) {
        if (untagStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)untagStreamRequest.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)untagStreamRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(untagStreamRequest.tagKeyList(), TAGKEYLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

