/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional input parameter for the <code>ListSignalingChannels</code> API. When this parameter is specified while
 * invoking <code>ListSignalingChannels</code>, the API returns only the channels that satisfy a condition specified in
 * <code>ChannelNameCondition</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelNameCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelNameCondition.Builder, ChannelNameCondition> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ChannelNameCondition::comparisonOperatorAsString)).setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<String> COMPARISON_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ChannelNameCondition::comparisonValue)).setter(setter(Builder::comparisonValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD,
            COMPARISON_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparisonOperator;

    private final String comparisonValue;

    private ChannelNameCondition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.comparisonValue = builder.comparisonValue;
    }

    /**
     * <p>
     * A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
     * signaling channels whose names begin with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
     *         signaling channels whose names begin with a given prefix.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
     * signaling channels whose names begin with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
     *         signaling channels whose names begin with a given prefix.
     * @see ComparisonOperator
     */
    public String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * A value to compare.
     * </p>
     * 
     * @return A value to compare.
     */
    public String comparisonValue() {
        return comparisonValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelNameCondition)) {
            return false;
        }
        ChannelNameCondition other = (ChannelNameCondition) obj;
        return Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(comparisonValue(), other.comparisonValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ChannelNameCondition").add("ComparisonOperator", comparisonOperatorAsString())
                .add("ComparisonValue", comparisonValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "ComparisonValue":
            return Optional.ofNullable(clazz.cast(comparisonValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelNameCondition, T> g) {
        return obj -> g.apply((ChannelNameCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelNameCondition> {
        /**
         * <p>
         * A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
         * signaling channels whose names begin with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which
         *        finds signaling channels whose names begin with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds
         * signaling channels whose names begin with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which
         *        finds signaling channels whose names begin with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * A value to compare.
         * </p>
         * 
         * @param comparisonValue
         *        A value to compare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonValue(String comparisonValue);
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOperator;

        private String comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelNameCondition model) {
            comparisonOperator(model.comparisonOperator);
            comparisonValue(model.comparisonValue);
        }

        public final String getComparisonOperatorAsString() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getComparisonValue() {
            return comparisonValue;
        }

        @Override
        public final Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        public final void setComparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
        }

        @Override
        public ChannelNameCondition build() {
            return new ChannelNameCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
