/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSignalingChannelRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateSignalingChannelRequest.Builder, UpdateSignalingChannelRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSignalingChannelRequest::channelARN)).setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSignalingChannelRequest::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField
            .<SingleMasterConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateSignalingChannelRequest::singleMasterConfiguration))
            .setter(setter(Builder::singleMasterConfiguration)).constructor(SingleMasterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CURRENT_VERSION_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD));

    private final String channelARN;

    private final String currentVersion;

    private final SingleMasterConfiguration singleMasterConfiguration;

    private UpdateSignalingChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.currentVersion = builder.currentVersion;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
    }

    /**
     * <p>
     * The ARN of the signaling channel that you want to update.
     * </p>
     * 
     * @return The ARN of the signaling channel that you want to update.
     */
    public String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * The current version of the signaling channel that you want to update.
     * </p>
     * 
     * @return The current version of the signaling channel that you want to update.
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that
     * you want to update.
     * </p>
     * 
     * @return The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling
     *         channel that you want to update.
     */
    public SingleMasterConfiguration singleMasterConfiguration() {
        return singleMasterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(singleMasterConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSignalingChannelRequest)) {
            return false;
        }
        UpdateSignalingChannelRequest other = (UpdateSignalingChannelRequest) obj;
        return Objects.equals(channelARN(), other.channelARN()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(singleMasterConfiguration(), other.singleMasterConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSignalingChannelRequest").add("ChannelARN", channelARN())
                .add("CurrentVersion", currentVersion()).add("SingleMasterConfiguration", singleMasterConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "SingleMasterConfiguration":
            return Optional.ofNullable(clazz.cast(singleMasterConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSignalingChannelRequest, T> g) {
        return obj -> g.apply((UpdateSignalingChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSignalingChannelRequest> {
        /**
         * <p>
         * The ARN of the signaling channel that you want to update.
         * </p>
         * 
         * @param channelARN
         *        The ARN of the signaling channel that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * The current version of the signaling channel that you want to update.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the signaling channel that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel
         * that you want to update.
         * </p>
         * 
         * @param singleMasterConfiguration
         *        The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling
         *        channel that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration);

        /**
         * <p>
         * The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel
         * that you want to update.
         * </p>
         * This is a convenience that creates an instance of the {@link SingleMasterConfiguration.Builder} avoiding the
         * need to create one manually via {@link SingleMasterConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingleMasterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #singleMasterConfiguration(SingleMasterConfiguration)}.
         * 
         * @param singleMasterConfiguration
         *        a consumer that will call methods on {@link SingleMasterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMasterConfiguration(SingleMasterConfiguration)
         */
        default Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return singleMasterConfiguration(SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String channelARN;

        private String currentVersion;

        private SingleMasterConfiguration singleMasterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSignalingChannelRequest model) {
            super(model);
            channelARN(model.channelARN);
            currentVersion(model.currentVersion);
            singleMasterConfiguration(model.singleMasterConfiguration);
        }

        public final String getChannelARN() {
            return channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return singleMasterConfiguration != null ? singleMasterConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSignalingChannelRequest build() {
            return new UpdateSignalingChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
