/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.StreamInfo;
import software.amazon.awssdk.services.kinesisvideo.model.StreamInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamsResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private static final SdkField<List<StreamInfo>> STREAM_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListStreamsResponse.getter(ListStreamsResponse::streamInfoList)).setter(ListStreamsResponse.setter(Builder::streamInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListStreamsResponse.getter(ListStreamsResponse::nextToken)).setter(ListStreamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<StreamInfo> streamInfoList;
    private final String nextToken;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streamInfoList = builder.streamInfoList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasStreamInfoList() {
        return this.streamInfoList != null && !(this.streamInfoList instanceof SdkAutoConstructList);
    }

    public List<StreamInfo> streamInfoList() {
        return this.streamInfoList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfoList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        return Objects.equals(this.streamInfoList(), other.streamInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsResponse").add("StreamInfoList", this.streamInfoList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamInfoList": {
                return Optional.ofNullable(clazz.cast(this.streamInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private List<StreamInfo> streamInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            this.streamInfoList(model.streamInfoList);
            this.nextToken(model.nextToken);
        }

        public final Collection<StreamInfo.Builder> getStreamInfoList() {
            return this.streamInfoList != null ? (Collection)this.streamInfoList.stream().map(StreamInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streamInfoList(Collection<StreamInfo> streamInfoList) {
            this.streamInfoList = StreamInfoListCopier.copy(streamInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamInfoList(StreamInfo ... streamInfoList) {
            this.streamInfoList(Arrays.asList(streamInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamInfoList(Consumer<StreamInfo.Builder> ... streamInfoList) {
            this.streamInfoList(Stream.of(streamInfoList).map(c -> (StreamInfo)((StreamInfo.Builder)StreamInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamInfoList(Collection<StreamInfo.BuilderImpl> streamInfoList) {
            this.streamInfoList = StreamInfoListCopier.copyFromBuilder(streamInfoList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streamInfoList(Collection<StreamInfo> var1);

        public Builder streamInfoList(StreamInfo ... var1);

        public Builder streamInfoList(Consumer<StreamInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

