/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSignalingChannelResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<DescribeSignalingChannelResponse.Builder, DescribeSignalingChannelResponse> {
    private static final SdkField<ChannelInfo> CHANNEL_INFO_FIELD = SdkField.<ChannelInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeSignalingChannelResponse::channelInfo)).setter(setter(Builder::channelInfo))
            .constructor(ChannelInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_INFO_FIELD));

    private final ChannelInfo channelInfo;

    private DescribeSignalingChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelInfo = builder.channelInfo;
    }

    /**
     * <p>
     * A structure that encapsulates the specified signaling channel's metadata and properties.
     * </p>
     * 
     * @return A structure that encapsulates the specified signaling channel's metadata and properties.
     */
    public ChannelInfo channelInfo() {
        return channelInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSignalingChannelResponse)) {
            return false;
        }
        DescribeSignalingChannelResponse other = (DescribeSignalingChannelResponse) obj;
        return Objects.equals(channelInfo(), other.channelInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSignalingChannelResponse").add("ChannelInfo", channelInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelInfo":
            return Optional.ofNullable(clazz.cast(channelInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSignalingChannelResponse, T> g) {
        return obj -> g.apply((DescribeSignalingChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSignalingChannelResponse> {
        /**
         * <p>
         * A structure that encapsulates the specified signaling channel's metadata and properties.
         * </p>
         * 
         * @param channelInfo
         *        A structure that encapsulates the specified signaling channel's metadata and properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelInfo(ChannelInfo channelInfo);

        /**
         * <p>
         * A structure that encapsulates the specified signaling channel's metadata and properties.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelInfo.Builder} avoiding the need to create
         * one manually via {@link ChannelInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #channelInfo(ChannelInfo)}.
         * 
         * @param channelInfo
         *        a consumer that will call methods on {@link ChannelInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelInfo(ChannelInfo)
         */
        default Builder channelInfo(Consumer<ChannelInfo.Builder> channelInfo) {
            return channelInfo(ChannelInfo.builder().applyMutation(channelInfo).build());
        }
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private ChannelInfo channelInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSignalingChannelResponse model) {
            super(model);
            channelInfo(model.channelInfo);
        }

        public final ChannelInfo.Builder getChannelInfo() {
            return channelInfo != null ? channelInfo.toBuilder() : null;
        }

        @Override
        public final Builder channelInfo(ChannelInfo channelInfo) {
            this.channelInfo = channelInfo;
            return this;
        }

        public final void setChannelInfo(ChannelInfo.BuilderImpl channelInfo) {
            this.channelInfo = channelInfo != null ? channelInfo.build() : null;
        }

        @Override
        public DescribeSignalingChannelResponse build() {
            return new DescribeSignalingChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
